// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The unit of data of the Kinesis data stream, which is composed of a sequence number, a partition key, and a data blob.
 */
public class Record private constructor(builder: Builder) {
    /**
     * The approximate time that the record was inserted into the stream.
     */
    public val approximateArrivalTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.approximateArrivalTimestamp
    /**
     * The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).
     */
    public val data: kotlin.ByteArray? = builder.data
    /**
     * The encryption type used on the record. This parameter can be one of the following values:
     * + `NONE`: Do not encrypt the records in the stream.
     * + `KMS`: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.
     */
    public val encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = builder.encryptionType
    /**
     * Identifies which shard in the stream the data record is assigned to.
     */
    public val partitionKey: kotlin.String? = builder.partitionKey
    /**
     * The unique identifier of the record within its shard.
     */
    public val sequenceNumber: kotlin.String? = builder.sequenceNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.Record = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Record(")
        append("approximateArrivalTimestamp=$approximateArrivalTimestamp,")
        append("data=$data,")
        append("encryptionType=$encryptionType,")
        append("partitionKey=$partitionKey,")
        append("sequenceNumber=$sequenceNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approximateArrivalTimestamp?.hashCode() ?: 0
        result = 31 * result + (data?.contentHashCode() ?: 0)
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (partitionKey?.hashCode() ?: 0)
        result = 31 * result + (sequenceNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Record

        if (approximateArrivalTimestamp != other.approximateArrivalTimestamp) return false
        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false
        if (encryptionType != other.encryptionType) return false
        if (partitionKey != other.partitionKey) return false
        if (sequenceNumber != other.sequenceNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.Record = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The approximate time that the record was inserted into the stream.
         */
        public var approximateArrivalTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The encryption type used on the record. This parameter can be one of the following values:
         * + `NONE`: Do not encrypt the records in the stream.
         * + `KMS`: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.
         */
        public var encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = null
        /**
         * Identifies which shard in the stream the data record is assigned to.
         */
        public var partitionKey: kotlin.String? = null
        /**
         * The unique identifier of the record within its shard.
         */
        public var sequenceNumber: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.Record) : this() {
            this.approximateArrivalTimestamp = x.approximateArrivalTimestamp
            this.data = x.data
            this.encryptionType = x.encryptionType
            this.partitionKey = x.partitionKey
            this.sequenceNumber = x.sequenceNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.Record = Record(this)
    }
}
