// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.ListStreamsResponse
import aws.sdk.kotlin.services.kinesis.model.StreamSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListStreamsOperationDeserializer: HttpDeserializer.NonStreaming<ListStreamsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListStreamsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListStreamsError(context, call, payload)
        }
        val builder = ListStreamsResponse.Builder()

        if (payload != null) {
            deserializeListStreamsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListStreamsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExpiredNextTokenException" -> ExpiredNextTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListStreamsOperationBody(builder: ListStreamsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HASMORESTREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HasMoreStreams"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STREAMNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("StreamNames"))
    val STREAMSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("StreamSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HASMORESTREAMS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STREAMNAMES_DESCRIPTOR)
        field(STREAMSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HASMORESTREAMS_DESCRIPTOR.index -> builder.hasMoreStreams = deserializeBoolean()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STREAMNAMES_DESCRIPTOR.index -> builder.streamNames =
                    deserializer.deserializeList(STREAMNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STREAMSUMMARIES_DESCRIPTOR.index -> builder.streamSummaries =
                    deserializer.deserializeList(STREAMSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<StreamSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStreamSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
