// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.DescribeLimitsResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeLimitsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLimitsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLimitsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLimitsError(context, call, payload)
        }
        val builder = DescribeLimitsResponse.Builder()

        if (payload != null) {
            deserializeDescribeLimitsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLimitsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLimitsOperationBody(builder: DescribeLimitsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ONDEMANDSTREAMCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OnDemandStreamCount"))
    val ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OnDemandStreamCountLimit"))
    val OPENSHARDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OpenShardCount"))
    val SHARDLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ShardLimit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ONDEMANDSTREAMCOUNT_DESCRIPTOR)
        field(ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR)
        field(OPENSHARDCOUNT_DESCRIPTOR)
        field(SHARDLIMIT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ONDEMANDSTREAMCOUNT_DESCRIPTOR.index -> builder.onDemandStreamCount = deserializeInt()
                ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR.index -> builder.onDemandStreamCountLimit = deserializeInt()
                OPENSHARDCOUNT_DESCRIPTOR.index -> builder.openShardCount = deserializeInt()
                SHARDLIMIT_DESCRIPTOR.index -> builder.shardLimit = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
