// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.AddTagsToStreamResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddTagsToStreamOperationDeserializer: HttpDeserializer.NonStreaming<AddTagsToStreamResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddTagsToStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddTagsToStreamError(context, call, payload)
        }
        val builder = AddTagsToStreamResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddTagsToStreamError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
