// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The starting position in the data stream from which to start streaming.
 */
public class StartingPosition private constructor(builder: Builder) {
    /**
     * The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set `StartingPosition` to `AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`.
     */
    public val sequenceNumber: kotlin.String? = builder.sequenceNumber
    /**
     * The time stamp of the data record from which to start reading. To specify a time stamp, set `StartingPosition` to `Type AT_TIMESTAMP`. A time stamp is the Unix epoch date with precision in milliseconds. For example, `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (`TRIM_HORIZON`).
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * You can set the starting position to one of the following values:
     *
     * `AT_SEQUENCE_NUMBER`: Start streaming from the position denoted by the sequence number specified in the `SequenceNumber` field.
     *
     * `AFTER_SEQUENCE_NUMBER`: Start streaming right after the position denoted by the sequence number specified in the `SequenceNumber` field.
     *
     * `AT_TIMESTAMP`: Start streaming from the position denoted by the time stamp specified in the `Timestamp` field.
     *
     * `TRIM_HORIZON`: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.
     *
     * `LATEST`: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    public val type: aws.sdk.kotlin.services.kinesis.model.ShardIteratorType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.StartingPosition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartingPosition(")
        append("sequenceNumber=$sequenceNumber,")
        append("timestamp=$timestamp,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sequenceNumber?.hashCode() ?: 0
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartingPosition

        if (sequenceNumber != other.sequenceNumber) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.StartingPosition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set `StartingPosition` to `AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`.
         */
        public var sequenceNumber: kotlin.String? = null
        /**
         * The time stamp of the data record from which to start reading. To specify a time stamp, set `StartingPosition` to `Type AT_TIMESTAMP`. A time stamp is the Unix epoch date with precision in milliseconds. For example, `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (`TRIM_HORIZON`).
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * You can set the starting position to one of the following values:
         *
         * `AT_SEQUENCE_NUMBER`: Start streaming from the position denoted by the sequence number specified in the `SequenceNumber` field.
         *
         * `AFTER_SEQUENCE_NUMBER`: Start streaming right after the position denoted by the sequence number specified in the `SequenceNumber` field.
         *
         * `AT_TIMESTAMP`: Start streaming from the position denoted by the time stamp specified in the `Timestamp` field.
         *
         * `TRIM_HORIZON`: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.
         *
         * `LATEST`: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.
         */
        public var type: aws.sdk.kotlin.services.kinesis.model.ShardIteratorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.StartingPosition) : this() {
            this.sequenceNumber = x.sequenceNumber
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.StartingPosition = StartingPosition(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = ShardIteratorType.SdkUnknown("no value provided")
            return this
        }
    }
}
