// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * `PutRecords` results.
 */
public class PutRecordsResponse private constructor(builder: Builder) {
    /**
     * The encryption type used on the records. This parameter can be one of the following values:
     * + `NONE`: Do not encrypt the records.
     * + `KMS`: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.
     */
    public val encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = builder.encryptionType
    /**
     * The number of unsuccessfully processed records in a `PutRecords` request.
     */
    public val failedRecordCount: kotlin.Int? = builder.failedRecordCount
    /**
     * An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes `SequenceNumber` and `ShardId` in the result. A record that fails to be added to a stream includes `ErrorCode` and `ErrorMessage` in the result.
     */
    public val records: List<PutRecordsResultEntry> = requireNotNull(builder.records) { "A non-null value must be provided for records" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.PutRecordsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecordsResponse(")
        append("encryptionType=$encryptionType,")
        append("failedRecordCount=$failedRecordCount,")
        append("records=$records")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType?.hashCode() ?: 0
        result = 31 * result + (failedRecordCount ?: 0)
        result = 31 * result + (records.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecordsResponse

        if (encryptionType != other.encryptionType) return false
        if (failedRecordCount != other.failedRecordCount) return false
        if (records != other.records) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.PutRecordsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption type used on the records. This parameter can be one of the following values:
         * + `NONE`: Do not encrypt the records.
         * + `KMS`: Use server-side encryption on the records using a customer-managed Amazon Web Services KMS key.
         */
        public var encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = null
        /**
         * The number of unsuccessfully processed records in a `PutRecords` request.
         */
        public var failedRecordCount: kotlin.Int? = null
        /**
         * An array of successfully and unsuccessfully processed record results. A record that is successfully added to a stream includes `SequenceNumber` and `ShardId` in the result. A record that fails to be added to a stream includes `ErrorCode` and `ErrorMessage` in the result.
         */
        public var records: List<PutRecordsResultEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.PutRecordsResponse) : this() {
            this.encryptionType = x.encryptionType
            this.failedRecordCount = x.failedRecordCount
            this.records = x.records
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.PutRecordsResponse = PutRecordsResponse(this)

        internal fun correctErrors(): Builder {
            if (records == null) records = emptyList()
            return this
        }
    }
}
