// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the output for `PutRecord`.
 */
public class PutRecordResponse private constructor(builder: Builder) {
    /**
     * The encryption type to use on the record. This parameter can be one of the following values:
     * + `NONE`: Do not encrypt the records in the stream.
     * + `KMS`: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.
     */
    public val encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = builder.encryptionType
    /**
     * The sequence number identifier that was assigned to the put data record. The sequence number for the record is unique across all records in the stream. A sequence number is the identifier associated with every record put into the stream.
     */
    public val sequenceNumber: kotlin.String = requireNotNull(builder.sequenceNumber) { "A non-null value must be provided for sequenceNumber" }
    /**
     * The shard ID of the shard where the data record was placed.
     */
    public val shardId: kotlin.String = requireNotNull(builder.shardId) { "A non-null value must be provided for shardId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.PutRecordResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecordResponse(")
        append("encryptionType=$encryptionType,")
        append("sequenceNumber=$sequenceNumber,")
        append("shardId=$shardId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType?.hashCode() ?: 0
        result = 31 * result + (sequenceNumber.hashCode())
        result = 31 * result + (shardId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecordResponse

        if (encryptionType != other.encryptionType) return false
        if (sequenceNumber != other.sequenceNumber) return false
        if (shardId != other.shardId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.PutRecordResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption type to use on the record. This parameter can be one of the following values:
         * + `NONE`: Do not encrypt the records in the stream.
         * + `KMS`: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.
         */
        public var encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = null
        /**
         * The sequence number identifier that was assigned to the put data record. The sequence number for the record is unique across all records in the stream. A sequence number is the identifier associated with every record put into the stream.
         */
        public var sequenceNumber: kotlin.String? = null
        /**
         * The shard ID of the shard where the data record was placed.
         */
        public var shardId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.PutRecordResponse) : this() {
            this.encryptionType = x.encryptionType
            this.sequenceNumber = x.sequenceNumber
            this.shardId = x.shardId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.PutRecordResponse = PutRecordResponse(this)

        internal fun correctErrors(): Builder {
            if (sequenceNumber == null) sequenceNumber = ""
            if (shardId == null) shardId = ""
            return this
        }
    }
}
