// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListShardsRequest private constructor(builder: Builder) {
    /**
     * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID immediately follows `ExclusiveStartShardId`.
     *
     * If you don't specify this parameter, the default behavior is for `ListShards` to list the shards starting with the first one in the stream.
     *
     * You cannot specify this parameter if you specify `NextToken`.
     */
    public val exclusiveStartShardId: kotlin.String? = builder.exclusiveStartShardId
    /**
     * The maximum number of shards to return in a single call to `ListShards`. The maximum number of shards to return in a single call. The default value is 1000. If you specify a value greater than 1000, at most 1000 results are returned.
     *
     * When the number of shards to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListShards` to list the next set of shards.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of shards in the data stream is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of shards in the data stream, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListShards` to list the next set of shards.
     *
     * Don't specify `StreamName` or `StreamCreationTimestamp` if you specify `NextToken` because the latter unambiguously identifies the stream.
     *
     * You can optionally specify a value for the `MaxResults` parameter when you specify `NextToken`. If you specify a `MaxResults` value that is less than the number of shards that the operation returns if you don't specify `MaxResults`, the response will contain a new `NextToken` value. You can use the new `NextToken` value in a subsequent call to the `ListShards` operation.
     *
     * Tokens expire after 300 seconds. When you obtain a value for `NextToken` in the response to a call to `ListShards`, you have 300 seconds to use that value. If you specify an expired token in a call to `ListShards`, you get `ExpiredNextTokenException`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Enables you to filter out the response of the `ListShards` API. You can only specify one filter at a time.
     *
     * If you use the `ShardFilter` parameter when invoking the ListShards API, the `Type` is the required property and must be specified. If you specify the `AT_TRIM_HORIZON`, `FROM_TRIM_HORIZON`, or `AT_LATEST` types, you do not need to specify either the `ShardId` or the `Timestamp` optional properties.
     *
     * If you specify the `AFTER_SHARD_ID` type, you must also provide the value for the optional `ShardId` property. The `ShardId` property is identical in fuctionality to the `ExclusiveStartShardId` parameter of the `ListShards` API. When `ShardId` property is specified, the response includes the shards starting with the shard whose ID immediately follows the `ShardId` that you provided.
     *
     * If you specify the `AT_TIMESTAMP` or `FROM_TIMESTAMP_ID` type, you must also provide the value for the optional `Timestamp` property. If you specify the AT_TIMESTAMP type, then all shards that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP type, then all shards starting from the provided timestamp to TIP are returned.
     */
    public val shardFilter: aws.sdk.kotlin.services.kinesis.model.ShardFilter? = builder.shardFilter
    /**
     * The ARN of the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the shards for.
     *
     * You cannot specify this parameter if you specify the `NextToken` parameter.
     */
    public val streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.streamCreationTimestamp
    /**
     * The name of the data stream whose shards you want to list.
     *
     * You cannot specify this parameter if you specify the `NextToken` parameter.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.ListShardsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListShardsRequest(")
        append("exclusiveStartShardId=$exclusiveStartShardId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("shardFilter=$shardFilter,")
        append("streamArn=$streamArn,")
        append("streamCreationTimestamp=$streamCreationTimestamp,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveStartShardId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (shardFilter?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamCreationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListShardsRequest

        if (exclusiveStartShardId != other.exclusiveStartShardId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (shardFilter != other.shardFilter) return false
        if (streamArn != other.streamArn) return false
        if (streamCreationTimestamp != other.streamCreationTimestamp) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.ListShardsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID immediately follows `ExclusiveStartShardId`.
         *
         * If you don't specify this parameter, the default behavior is for `ListShards` to list the shards starting with the first one in the stream.
         *
         * You cannot specify this parameter if you specify `NextToken`.
         */
        public var exclusiveStartShardId: kotlin.String? = null
        /**
         * The maximum number of shards to return in a single call to `ListShards`. The maximum number of shards to return in a single call. The default value is 1000. If you specify a value greater than 1000, at most 1000 results are returned.
         *
         * When the number of shards to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListShards` to list the next set of shards.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of shards in the data stream is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of shards in the data stream, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListShards` to list the next set of shards.
         *
         * Don't specify `StreamName` or `StreamCreationTimestamp` if you specify `NextToken` because the latter unambiguously identifies the stream.
         *
         * You can optionally specify a value for the `MaxResults` parameter when you specify `NextToken`. If you specify a `MaxResults` value that is less than the number of shards that the operation returns if you don't specify `MaxResults`, the response will contain a new `NextToken` value. You can use the new `NextToken` value in a subsequent call to the `ListShards` operation.
         *
         * Tokens expire after 300 seconds. When you obtain a value for `NextToken` in the response to a call to `ListShards`, you have 300 seconds to use that value. If you specify an expired token in a call to `ListShards`, you get `ExpiredNextTokenException`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Enables you to filter out the response of the `ListShards` API. You can only specify one filter at a time.
         *
         * If you use the `ShardFilter` parameter when invoking the ListShards API, the `Type` is the required property and must be specified. If you specify the `AT_TRIM_HORIZON`, `FROM_TRIM_HORIZON`, or `AT_LATEST` types, you do not need to specify either the `ShardId` or the `Timestamp` optional properties.
         *
         * If you specify the `AFTER_SHARD_ID` type, you must also provide the value for the optional `ShardId` property. The `ShardId` property is identical in fuctionality to the `ExclusiveStartShardId` parameter of the `ListShards` API. When `ShardId` property is specified, the response includes the shards starting with the shard whose ID immediately follows the `ShardId` that you provided.
         *
         * If you specify the `AT_TIMESTAMP` or `FROM_TIMESTAMP_ID` type, you must also provide the value for the optional `Timestamp` property. If you specify the AT_TIMESTAMP type, then all shards that were open at the provided timestamp are returned. If you specify the FROM_TIMESTAMP type, then all shards starting from the provided timestamp to TIP are returned.
         */
        public var shardFilter: aws.sdk.kotlin.services.kinesis.model.ShardFilter? = null
        /**
         * The ARN of the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the shards for.
         *
         * You cannot specify this parameter if you specify the `NextToken` parameter.
         */
        public var streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the data stream whose shards you want to list.
         *
         * You cannot specify this parameter if you specify the `NextToken` parameter.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.ListShardsRequest) : this() {
            this.exclusiveStartShardId = x.exclusiveStartShardId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.shardFilter = x.shardFilter
            this.streamArn = x.streamArn
            this.streamCreationTimestamp = x.streamCreationTimestamp
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.ListShardsRequest = ListShardsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.ShardFilter] inside the given [block]
         */
        public fun shardFilter(block: aws.sdk.kotlin.services.kinesis.model.ShardFilter.Builder.() -> kotlin.Unit) {
            this.shardFilter = aws.sdk.kotlin.services.kinesis.model.ShardFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
