// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input for EnableEnhancedMonitoring.
 */
public class EnableEnhancedMonitoringRequest private constructor(builder: Builder) {
    /**
     * List of shard-level metrics to enable.
     *
     * The following are the valid shard-level metrics. The value "`ALL`" enables every metric.
     * + `IncomingBytes`
     * + `IncomingRecords`
     * + `OutgoingBytes`
     * + `OutgoingRecords`
     * + `WriteProvisionedThroughputExceeded`
     * + `ReadProvisionedThroughputExceeded`
     * + `IteratorAgeMilliseconds`
     * + `ALL`
     *
     * For more information, see [Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch](https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html) in the *Amazon Kinesis Data Streams Developer Guide*.
     */
    public val shardLevelMetrics: List<MetricsName>? = builder.shardLevelMetrics
    /**
     * The ARN of the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream for which to enable enhanced monitoring.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableEnhancedMonitoringRequest(")
        append("shardLevelMetrics=$shardLevelMetrics,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = shardLevelMetrics?.hashCode() ?: 0
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableEnhancedMonitoringRequest

        if (shardLevelMetrics != other.shardLevelMetrics) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of shard-level metrics to enable.
         *
         * The following are the valid shard-level metrics. The value "`ALL`" enables every metric.
         * + `IncomingBytes`
         * + `IncomingRecords`
         * + `OutgoingBytes`
         * + `OutgoingRecords`
         * + `WriteProvisionedThroughputExceeded`
         * + `ReadProvisionedThroughputExceeded`
         * + `IteratorAgeMilliseconds`
         * + `ALL`
         *
         * For more information, see [Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch](https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html) in the *Amazon Kinesis Data Streams Developer Guide*.
         */
        public var shardLevelMetrics: List<MetricsName>? = null
        /**
         * The ARN of the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The name of the stream for which to enable enhanced monitoring.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest) : this() {
            this.shardLevelMetrics = x.shardLevelMetrics
            this.streamArn = x.streamArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest = EnableEnhancedMonitoringRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
