// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input for `DescribeStream`.
 */
public class DescribeStreamRequest private constructor(builder: Builder) {
    /**
     * The shard ID of the shard to start with.
     *
     * Specify this parameter to indicate that you want to describe the stream starting with the shard whose ID immediately follows `ExclusiveStartShardId`.
     *
     * If you don't specify this parameter, the default behavior for `DescribeStream` is to describe the stream starting with the first shard in the stream.
     */
    public val exclusiveStartShardId: kotlin.String? = builder.exclusiveStartShardId
    /**
     * The maximum number of shards to return in a single call. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The ARN of the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream to describe.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStreamRequest(")
        append("exclusiveStartShardId=$exclusiveStartShardId,")
        append("limit=$limit,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveStartShardId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStreamRequest

        if (exclusiveStartShardId != other.exclusiveStartShardId) return false
        if (limit != other.limit) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The shard ID of the shard to start with.
         *
         * Specify this parameter to indicate that you want to describe the stream starting with the shard whose ID immediately follows `ExclusiveStartShardId`.
         *
         * If you don't specify this parameter, the default behavior for `DescribeStream` is to describe the stream starting with the first shard in the stream.
         */
        public var exclusiveStartShardId: kotlin.String? = null
        /**
         * The maximum number of shards to return in a single call. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.
         */
        public var limit: kotlin.Int? = null
        /**
         * The ARN of the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The name of the stream to describe.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest) : this() {
            this.exclusiveStartShardId = x.exclusiveStartShardId
            this.limit = x.limit
            this.streamArn = x.streamArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest = DescribeStreamRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
