// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.endpoints



/**
 * The set of values necessary for endpoint resolution.
 */
public class KinesisEndpointParameters private constructor(builder: Builder) {
    /**
     * The ARN of the Kinesis consumer
     */
    public val consumerArn: String? = builder.consumerArn

    /**
     * Override the endpoint used to send this request
     */
    public val endpoint: String? = builder.endpoint

    /**
     * Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
     */
    public val operationType: String? = builder.operationType

    /**
     * The AWS region used to dispatch the request.
     */
    public val region: String? = builder.region

    /**
     * The ARN of the Kinesis resource
     */
    public val resourceArn: String? = builder.resourceArn

    /**
     * The ARN of the Kinesis stream
     */
    public val streamArn: String? = builder.streamArn

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
     */
    public val useDualStack: Boolean? = requireNotNull(builder.useDualStack) { "endpoint provider parameter #useDualStack is required" }

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
     */
    public val useFips: Boolean? = requireNotNull(builder.useFips) { "endpoint provider parameter #useFips is required" }

    public companion object {
        public inline operator fun invoke(block: Builder.() -> Unit): KinesisEndpointParameters = Builder().apply(block).build()
    }

    public override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is KinesisEndpointParameters) return false
        if (this.consumerArn != other.consumerArn) return false
        if (this.endpoint != other.endpoint) return false
        if (this.operationType != other.operationType) return false
        if (this.region != other.region) return false
        if (this.resourceArn != other.resourceArn) return false
        if (this.streamArn != other.streamArn) return false
        if (this.useDualStack != other.useDualStack) return false
        if (this.useFips != other.useFips) return false
        return true
    }

    public override fun hashCode(): Int {
        var result = consumerArn?.hashCode() ?: 0
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (useDualStack?.hashCode() ?: 0)
        result = 31 * result + (useFips?.hashCode() ?: 0)
        return result
    }

    public override fun toString(): String = buildString {
        append("KinesisEndpointParameters(")
        append("consumerArn=$consumerArn,")
        append("endpoint=$endpoint,")
        append("operationType=$operationType,")
        append("region=$region,")
        append("resourceArn=$resourceArn,")
        append("streamArn=$streamArn,")
        append("useDualStack=$useDualStack,")
        append("useFips=$useFips)")
    }

    public fun copy(block: Builder.() -> Unit = {}): KinesisEndpointParameters {
        return Builder().apply {
            consumerArn = this@KinesisEndpointParameters.consumerArn
            endpoint = this@KinesisEndpointParameters.endpoint
            operationType = this@KinesisEndpointParameters.operationType
            region = this@KinesisEndpointParameters.region
            resourceArn = this@KinesisEndpointParameters.resourceArn
            streamArn = this@KinesisEndpointParameters.streamArn
            useDualStack = this@KinesisEndpointParameters.useDualStack
            useFips = this@KinesisEndpointParameters.useFips
            block()
        }
        .build()
    }

    public class Builder {
        /**
         * The ARN of the Kinesis consumer
         */
        public var consumerArn: String? = null

        /**
         * Override the endpoint used to send this request
         */
        public var endpoint: String? = null

        /**
         * Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
         */
        public var operationType: String? = null

        /**
         * The AWS region used to dispatch the request.
         */
        public var region: String? = null

        /**
         * The ARN of the Kinesis resource
         */
        public var resourceArn: String? = null

        /**
         * The ARN of the Kinesis stream
         */
        public var streamArn: String? = null

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
         */
        public var useDualStack: Boolean? = false

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        public var useFips: Boolean? = false

        public fun build(): KinesisEndpointParameters = KinesisEndpointParameters(this)
    }
}
