// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.endpoints

import aws.sdk.kotlin.runtime.endpoint.functions.parseArn
import aws.sdk.kotlin.services.kinesis.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.functions.isValidHostLabel
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultKinesisEndpointProvider: KinesisEndpointProvider {
    public override suspend fun resolveEndpoint(params: KinesisEndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.streamArn != null &&
                !(params.endpoint != null) &&
                params.region != null &&
                !(partitionResult?.name == "aws-iso") &&
                !(partitionResult?.name == "aws-iso-b")
            ) {
                run {
                    val arn = parseArn(params.streamArn)
                    if (
                        arn != null
                    ) {
                        if (
                            isValidHostLabel(arn?.accountId, false)
                        ) {
                            if (
                                isValidHostLabel(arn?.region, false)
                            ) {
                                if (
                                    arn?.service == "kinesis"
                                ) {
                                    run {
                                        val arnType = arn?.resourceId?.getOrNull(0)
                                        if (
                                            arnType != null &&
                                            !(arnType == "")
                                        ) {
                                            if (
                                                arnType == "stream"
                                            ) {
                                                if (
                                                    partitionResult?.name == "${arn?.partition}"
                                                ) {
                                                    if (
                                                        params.operationType != null
                                                    ) {
                                                        if (
                                                            params.useFips == true &&
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                if (
                                                                    partitionResult?.supportsDualStack == true
                                                                ) {
                                                                    return Endpoint(
                                                                        Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                    )
                                                                }
                                                                throw EndpointProviderException("DualStack is enabled, but this partition does not support DualStack.")
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled, but this partition does not support FIPS.")
                                                        }
                                                        if (
                                                            params.useFips == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                                                        }
                                                        if (
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsDualStack == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                                                        }
                                                        return Endpoint(
                                                            Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dnsSuffix}"),
                                                        )
                                                    }
                                                    throw EndpointProviderException("Operation Type is not set. Please contact service team for resolution.")
                                                }
                                                throw EndpointProviderException("Partition: ${arn?.partition} from ARN doesn't match with partition name: ${partitionResult?.name}.")
                                            }
                                            throw EndpointProviderException("Invalid ARN: Kinesis ARNs don't support `${arnType}` arn types.")
                                        }
                                    }
                                    throw EndpointProviderException("Invalid ARN: No ARN type specified")
                                }
                                throw EndpointProviderException("Invalid ARN: The ARN was not for the Kinesis service, found: ${arn?.service}.")
                            }
                            throw EndpointProviderException("Invalid ARN: Invalid region.")
                        }
                        throw EndpointProviderException("Invalid ARN: Invalid account id.")
                    }
                }
                throw EndpointProviderException("Invalid ARN: Failed to parse ARN.")
            }
        }
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.consumerArn != null &&
                !(params.endpoint != null) &&
                params.region != null &&
                !(partitionResult?.name == "aws-iso") &&
                !(partitionResult?.name == "aws-iso-b")
            ) {
                run {
                    val arn = parseArn(params.consumerArn)
                    if (
                        arn != null
                    ) {
                        if (
                            isValidHostLabel(arn?.accountId, false)
                        ) {
                            if (
                                isValidHostLabel(arn?.region, false)
                            ) {
                                if (
                                    arn?.service == "kinesis"
                                ) {
                                    run {
                                        val arnType = arn?.resourceId?.getOrNull(0)
                                        if (
                                            arnType != null &&
                                            !(arnType == "")
                                        ) {
                                            if (
                                                arnType == "stream"
                                            ) {
                                                if (
                                                    partitionResult?.name == "${arn?.partition}"
                                                ) {
                                                    if (
                                                        params.operationType != null
                                                    ) {
                                                        if (
                                                            params.useFips == true &&
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                if (
                                                                    partitionResult?.supportsDualStack == true
                                                                ) {
                                                                    return Endpoint(
                                                                        Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                    )
                                                                }
                                                                throw EndpointProviderException("DualStack is enabled, but this partition does not support DualStack.")
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled, but this partition does not support FIPS.")
                                                        }
                                                        if (
                                                            params.useFips == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                                                        }
                                                        if (
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsDualStack == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                                                        }
                                                        return Endpoint(
                                                            Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dnsSuffix}"),
                                                        )
                                                    }
                                                    throw EndpointProviderException("Operation Type is not set. Please contact service team for resolution.")
                                                }
                                                throw EndpointProviderException("Partition: ${arn?.partition} from ARN doesn't match with partition name: ${partitionResult?.name}.")
                                            }
                                            throw EndpointProviderException("Invalid ARN: Kinesis ARNs don't support `${arnType}` arn types.")
                                        }
                                    }
                                    throw EndpointProviderException("Invalid ARN: No ARN type specified")
                                }
                                throw EndpointProviderException("Invalid ARN: The ARN was not for the Kinesis service, found: ${arn?.service}.")
                            }
                            throw EndpointProviderException("Invalid ARN: Invalid region.")
                        }
                        throw EndpointProviderException("Invalid ARN: Invalid account id.")
                    }
                }
                throw EndpointProviderException("Invalid ARN: Failed to parse ARN.")
            }
        }
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.resourceArn != null &&
                !(params.endpoint != null) &&
                params.region != null &&
                !(partitionResult?.name == "aws-iso") &&
                !(partitionResult?.name == "aws-iso-b")
            ) {
                run {
                    val arn = parseArn(params.resourceArn)
                    if (
                        arn != null
                    ) {
                        if (
                            isValidHostLabel(arn?.accountId, false)
                        ) {
                            if (
                                isValidHostLabel(arn?.region, false)
                            ) {
                                if (
                                    arn?.service == "kinesis"
                                ) {
                                    run {
                                        val arnType = arn?.resourceId?.getOrNull(0)
                                        if (
                                            arnType != null &&
                                            !(arnType == "")
                                        ) {
                                            if (
                                                arnType == "stream"
                                            ) {
                                                if (
                                                    partitionResult?.name == "${arn?.partition}"
                                                ) {
                                                    if (
                                                        params.operationType != null
                                                    ) {
                                                        if (
                                                            params.useFips == true &&
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                if (
                                                                    partitionResult?.supportsDualStack == true
                                                                ) {
                                                                    return Endpoint(
                                                                        Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                    )
                                                                }
                                                                throw EndpointProviderException("DualStack is enabled, but this partition does not support DualStack.")
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled, but this partition does not support FIPS.")
                                                        }
                                                        if (
                                                            params.useFips == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsFIPS == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                                                        }
                                                        if (
                                                            params.useDualStack == true
                                                        ) {
                                                            if (
                                                                partitionResult?.supportsDualStack == true
                                                            ) {
                                                                return Endpoint(
                                                                    Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                                                )
                                                            }
                                                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                                                        }
                                                        return Endpoint(
                                                            Url.parse("https://${arn?.accountId}.${params.operationType}-kinesis.${params.region}.${partitionResult?.dnsSuffix}"),
                                                        )
                                                    }
                                                    throw EndpointProviderException("Operation Type is not set. Please contact service team for resolution.")
                                                }
                                                throw EndpointProviderException("Partition: ${arn?.partition} from ARN doesn't match with partition name: ${partitionResult?.name}.")
                                            }
                                            throw EndpointProviderException("Invalid ARN: Kinesis ARNs don't support `${arnType}` arn types.")
                                        }
                                    }
                                    throw EndpointProviderException("Invalid ARN: No ARN type specified")
                                }
                                throw EndpointProviderException("Invalid ARN: The ARN was not for the Kinesis service, found: ${arn?.service}.")
                            }
                            throw EndpointProviderException("Invalid ARN: Invalid region.")
                        }
                        throw EndpointProviderException("Invalid ARN: Invalid account id.")
                    }
                }
                throw EndpointProviderException("Invalid ARN: Failed to parse ARN.")
            }
        }
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://kinesis-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            if (
                                partitionResult?.name == "aws-us-gov"
                            ) {
                                return Endpoint(
                                    Url.parse("https://kinesis.${params.region}.amazonaws.com"),
                                )
                            }
                            return Endpoint(
                                Url.parse("https://kinesis-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://kinesis.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://kinesis.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
