// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.mergeSequential
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.SubscribeToShardEventStream
import aws.sdk.kotlin.services.kinesis.model.SubscribeToShardResponse
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flowOf
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.flow.single
import kotlinx.coroutines.flow.take


internal class SubscribeToShardOperationDeserializer: HttpDeserialize<SubscribeToShardResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SubscribeToShardResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSubscribeToShardError(context, call)
        }
        val builder = SubscribeToShardResponse.Builder()

        deserializeSubscribeToShardOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSubscribeToShardError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeSubscribeToShardOperationBody(builder: SubscribeToShardResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val firstMessage = frames.take(1).single()
    val firstMessageType = firstMessage.type()
    val events = if (firstMessageType is MessageType.Event && firstMessageType.shapeType == "initial-response") {
        val initialResponse = deserializeSubscribeToShardResponsePayloadoDjO66AN(firstMessage.payload)
        builder.apply {
        }
        frames
    } else {
        mergeSequential(flowOf(firstMessage), frames)
    }
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "SubscribeToShardEvent" -> {
                        val e = deserializeSubscribeToShardEventPayload(message.payload)
                        SubscribeToShardEventStream.SubscribeToShardEvent(e)
                    }
                    else -> SubscribeToShardEventStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    "ResourceNotFoundException" -> {
                        val err = deserializeResourceNotFoundExceptionPayload(message.payload)
                        throw err
                    }
                    "ResourceInUseException" -> {
                        val err = deserializeResourceInUseExceptionPayload(message.payload)
                        throw err
                    }
                    "KMSDisabledException" -> {
                        val err = deserializeKmsDisabledExceptionPayload(message.payload)
                        throw err
                    }
                    "KMSInvalidStateException" -> {
                        val err = deserializeKmsInvalidStateExceptionPayload(message.payload)
                        throw err
                    }
                    "KMSAccessDeniedException" -> {
                        val err = deserializeKmsAccessDeniedExceptionPayload(message.payload)
                        throw err
                    }
                    "KMSNotFoundException" -> {
                        val err = deserializeKmsNotFoundExceptionPayload(message.payload)
                        throw err
                    }
                    "KMSOptInRequired" -> {
                        val err = deserializeKmsOptInRequiredPayload(message.payload)
                        throw err
                    }
                    "KMSThrottlingException" -> {
                        val err = deserializeKmsThrottlingExceptionPayload(message.payload)
                        throw err
                    }
                    "InternalFailureException" -> {
                        val err = deserializeInternalFailureExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw KinesisException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw KinesisException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.eventStream = events
}
