// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.EncryptionType
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.PutRecordResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutRecordOperationDeserializer: HttpDeserialize<PutRecordResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutRecordResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRecordError(context, call)
        }
        val builder = PutRecordResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutRecordOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutRecordError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall)
        "KMSThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutRecordOperationBody(builder: PutRecordResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EncryptionType"))
    val SEQUENCENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SequenceNumber"))
    val SHARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ShardId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENCRYPTIONTYPE_DESCRIPTOR)
        field(SEQUENCENUMBER_DESCRIPTOR)
        field(SHARDID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENCRYPTIONTYPE_DESCRIPTOR.index -> builder.encryptionType = deserializeString().let { EncryptionType.fromValue(it) }
                SEQUENCENUMBER_DESCRIPTOR.index -> builder.sequenceNumber = deserializeString()
                SHARDID_DESCRIPTOR.index -> builder.shardId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
