// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.ChildShard
import aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.Record
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetRecordsOperationDeserializer: HttpDeserialize<GetRecordsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetRecordsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRecordsError(context, call)
        }
        val builder = GetRecordsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecordsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetRecordsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ExpiredIteratorException" -> ExpiredIteratorExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall)
        "KMSThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecordsOperationBody(builder: GetRecordsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHILDSHARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ChildShards"))
    val MILLISBEHINDLATEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MillisBehindLatest"))
    val NEXTSHARDITERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextShardIterator"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHILDSHARDS_DESCRIPTOR)
        field(MILLISBEHINDLATEST_DESCRIPTOR)
        field(NEXTSHARDITERATOR_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHILDSHARDS_DESCRIPTOR.index -> builder.childShards =
                    deserializer.deserializeList(CHILDSHARDS_DESCRIPTOR) {
                        val col0 = mutableListOf<ChildShard>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChildShardDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MILLISBEHINDLATEST_DESCRIPTOR.index -> builder.millisBehindLatest = deserializeLong()
                NEXTSHARDITERATOR_DESCRIPTOR.index -> builder.nextShardIterator = deserializeString()
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<Record>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
