// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.MetricsName
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class EnableEnhancedMonitoringOperationDeserializer: HttpDeserialize<EnableEnhancedMonitoringResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): EnableEnhancedMonitoringResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEnableEnhancedMonitoringError(context, call)
        }
        val builder = EnableEnhancedMonitoringResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeEnableEnhancedMonitoringOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwEnableEnhancedMonitoringError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEnableEnhancedMonitoringOperationBody(builder: EnableEnhancedMonitoringResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CURRENTSHARDLEVELMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CurrentShardLevelMetrics"))
    val DESIREDSHARDLEVELMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DesiredShardLevelMetrics"))
    val STREAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamARN"))
    val STREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTSHARDLEVELMETRICS_DESCRIPTOR)
        field(DESIREDSHARDLEVELMETRICS_DESCRIPTOR)
        field(STREAMARN_DESCRIPTOR)
        field(STREAMNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENTSHARDLEVELMETRICS_DESCRIPTOR.index -> builder.currentShardLevelMetrics =
                    deserializer.deserializeList(CURRENTSHARDLEVELMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricsName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { MetricsName.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESIREDSHARDLEVELMETRICS_DESCRIPTOR.index -> builder.desiredShardLevelMetrics =
                    deserializer.deserializeList(DESIREDSHARDLEVELMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricsName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { MetricsName.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STREAMARN_DESCRIPTOR.index -> builder.streamArn = deserializeString()
                STREAMNAME_DESCRIPTOR.index -> builder.streamName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
