// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.serde

import aws.sdk.kotlin.services.kinesis.model.DeregisterStreamConsumerResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeregisterStreamConsumerOperationDeserializer: HttpDeserialize<DeregisterStreamConsumerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeregisterStreamConsumerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterStreamConsumerError(context, call)
        }
        val builder = DeregisterStreamConsumerResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeregisterStreamConsumerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
