// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * After you call SubscribeToShard, Kinesis Data Streams sends events of this type over an HTTP/2 connection to your consumer.
 */
public class SubscribeToShardEvent private constructor(builder: Builder) {
    /**
     * The list of the child shards of the current shard, returned only at the end of the current shard.
     */
    public val childShards: List<ChildShard>? = builder.childShards
    /**
     * Use this as `SequenceNumber` in the next call to SubscribeToShard, with `StartingPosition` set to `AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`. Use `ContinuationSequenceNumber` for checkpointing because it captures your shard progress even when no data is written to the shard.
     */
    public val continuationSequenceNumber: kotlin.String = requireNotNull(builder.continuationSequenceNumber) { "A non-null value must be provided for continuationSequenceNumber" }
    /**
     * The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.
     */
    public val millisBehindLatest: kotlin.Long = requireNotNull(builder.millisBehindLatest) { "A non-null value must be provided for millisBehindLatest" }
    /**
     *
     */
    public val records: List<Record> = requireNotNull(builder.records) { "A non-null value must be provided for records" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.SubscribeToShardEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscribeToShardEvent(")
        append("childShards=$childShards,")
        append("continuationSequenceNumber=$continuationSequenceNumber,")
        append("millisBehindLatest=$millisBehindLatest,")
        append("records=$records")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childShards?.hashCode() ?: 0
        result = 31 * result + (continuationSequenceNumber.hashCode())
        result = 31 * result + (millisBehindLatest.hashCode())
        result = 31 * result + (records.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscribeToShardEvent

        if (childShards != other.childShards) return false
        if (continuationSequenceNumber != other.continuationSequenceNumber) return false
        if (millisBehindLatest != other.millisBehindLatest) return false
        if (records != other.records) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.SubscribeToShardEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of the child shards of the current shard, returned only at the end of the current shard.
         */
        public var childShards: List<ChildShard>? = null
        /**
         * Use this as `SequenceNumber` in the next call to SubscribeToShard, with `StartingPosition` set to `AT_SEQUENCE_NUMBER` or `AFTER_SEQUENCE_NUMBER`. Use `ContinuationSequenceNumber` for checkpointing because it captures your shard progress even when no data is written to the shard.
         */
        public var continuationSequenceNumber: kotlin.String? = null
        /**
         * The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.
         */
        public var millisBehindLatest: kotlin.Long? = null
        /**
         *
         */
        public var records: List<Record>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.SubscribeToShardEvent) : this() {
            this.childShards = x.childShards
            this.continuationSequenceNumber = x.continuationSequenceNumber
            this.millisBehindLatest = x.millisBehindLatest
            this.records = x.records
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.SubscribeToShardEvent = SubscribeToShardEvent(this)

        internal fun correctErrors(): Builder {
            if (continuationSequenceNumber == null) continuationSequenceNumber = ""
            if (millisBehindLatest == null) millisBehindLatest = 0L
            if (records == null) records = emptyList()
            return this
        }
    }
}
