// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of a stream.
 */
public class StreamSummary private constructor(builder: Builder) {
    /**
     * The ARN of the stream.
     */
    public val streamArn: kotlin.String = requireNotNull(builder.streamArn) { "A non-null value must be provided for streamArn" }
    /**
     * The timestamp at which the stream was created.
     */
    public val streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.streamCreationTimestamp
    /**
     * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** capacity mode and a **provisioned** capacity mode for your data streams.
     */
    public val streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = builder.streamModeDetails
    /**
     * The name of a stream.
     */
    public val streamName: kotlin.String = requireNotNull(builder.streamName) { "A non-null value must be provided for streamName" }
    /**
     * The status of the stream.
     */
    public val streamStatus: aws.sdk.kotlin.services.kinesis.model.StreamStatus = requireNotNull(builder.streamStatus) { "A non-null value must be provided for streamStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.StreamSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamSummary(")
        append("streamArn=$streamArn,")
        append("streamCreationTimestamp=$streamCreationTimestamp,")
        append("streamModeDetails=$streamModeDetails,")
        append("streamName=$streamName,")
        append("streamStatus=$streamStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = streamArn.hashCode()
        result = 31 * result + (streamCreationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (streamModeDetails?.hashCode() ?: 0)
        result = 31 * result + (streamName.hashCode())
        result = 31 * result + (streamStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamSummary

        if (streamArn != other.streamArn) return false
        if (streamCreationTimestamp != other.streamCreationTimestamp) return false
        if (streamModeDetails != other.streamModeDetails) return false
        if (streamName != other.streamName) return false
        if (streamStatus != other.streamStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.StreamSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The timestamp at which the stream was created.
         */
        public var streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** capacity mode and a **provisioned** capacity mode for your data streams.
         */
        public var streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = null
        /**
         * The name of a stream.
         */
        public var streamName: kotlin.String? = null
        /**
         * The status of the stream.
         */
        public var streamStatus: aws.sdk.kotlin.services.kinesis.model.StreamStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.StreamSummary) : this() {
            this.streamArn = x.streamArn
            this.streamCreationTimestamp = x.streamCreationTimestamp
            this.streamModeDetails = x.streamModeDetails
            this.streamName = x.streamName
            this.streamStatus = x.streamStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.StreamSummary = StreamSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.StreamModeDetails] inside the given [block]
         */
        public fun streamModeDetails(block: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.Builder.() -> kotlin.Unit) {
            this.streamModeDetails = aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (streamArn == null) streamArn = ""
            if (streamName == null) streamName = ""
            if (streamStatus == null) streamStatus = StreamStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
