// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output for DescribeStreamSummary
 */
public class StreamDescriptionSummary private constructor(builder: Builder) {
    /**
     * The number of enhanced fan-out consumers registered with the stream.
     */
    public val consumerCount: kotlin.Int? = builder.consumerCount
    /**
     * The encryption type used. This value is one of the following:
     * + `KMS`
     * + `NONE`
     */
    public val encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = builder.encryptionType
    /**
     * Represents the current enhanced monitoring settings of the stream.
     */
    public val enhancedMonitoring: List<EnhancedMetrics> = requireNotNull(builder.enhancedMonitoring) { "A non-null value must be provided for enhancedMonitoring" }
    /**
     * The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias `aws/kinesis`.
     * + Key ARN example: `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
     * + Alias ARN example: ` arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
     * + Globally unique key ID example: `12345678-1234-1234-1234-123456789012`
     * + Alias name example: `alias/MyAliasName`
     * + Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The number of open shards in the stream.
     */
    public val openShardCount: kotlin.Int = requireNotNull(builder.openShardCount) { "A non-null value must be provided for openShardCount" }
    /**
     * The current retention period, in hours.
     */
    public val retentionPeriodHours: kotlin.Int = requireNotNull(builder.retentionPeriodHours) { "A non-null value must be provided for retentionPeriodHours" }
    /**
     * The Amazon Resource Name (ARN) for the stream being described.
     */
    public val streamArn: kotlin.String = requireNotNull(builder.streamArn) { "A non-null value must be provided for streamArn" }
    /**
     * The approximate time that the stream was created.
     */
    public val streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.streamCreationTimestamp) { "A non-null value must be provided for streamCreationTimestamp" }
    /**
     * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** ycapacity mode and a **provisioned** capacity mode for your data streams.
     */
    public val streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = builder.streamModeDetails
    /**
     * The name of the stream being described.
     */
    public val streamName: kotlin.String = requireNotNull(builder.streamName) { "A non-null value must be provided for streamName" }
    /**
     * The current status of the stream being described. The stream status is one of the following states:
     * + `CREATING` - The stream is being created. Kinesis Data Streams immediately returns and sets `StreamStatus` to `CREATING`.
     * + `DELETING` - The stream is being deleted. The specified stream is in the `DELETING` state until Kinesis Data Streams completes the deletion.
     * + `ACTIVE` - The stream exists and is ready for read and write operations or deletion. You should perform read and write operations only on an `ACTIVE` stream.
     * + `UPDATING` - Shards in the stream are being merged or split. Read and write operations continue to work while the stream is in the `UPDATING` state.
     */
    public val streamStatus: aws.sdk.kotlin.services.kinesis.model.StreamStatus = requireNotNull(builder.streamStatus) { "A non-null value must be provided for streamStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.StreamDescriptionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamDescriptionSummary(")
        append("consumerCount=$consumerCount,")
        append("encryptionType=$encryptionType,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("keyId=$keyId,")
        append("openShardCount=$openShardCount,")
        append("retentionPeriodHours=$retentionPeriodHours,")
        append("streamArn=$streamArn,")
        append("streamCreationTimestamp=$streamCreationTimestamp,")
        append("streamModeDetails=$streamModeDetails,")
        append("streamName=$streamName,")
        append("streamStatus=$streamStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerCount ?: 0
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring.hashCode())
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (openShardCount)
        result = 31 * result + (retentionPeriodHours)
        result = 31 * result + (streamArn.hashCode())
        result = 31 * result + (streamCreationTimestamp.hashCode())
        result = 31 * result + (streamModeDetails?.hashCode() ?: 0)
        result = 31 * result + (streamName.hashCode())
        result = 31 * result + (streamStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamDescriptionSummary

        if (consumerCount != other.consumerCount) return false
        if (encryptionType != other.encryptionType) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (keyId != other.keyId) return false
        if (openShardCount != other.openShardCount) return false
        if (retentionPeriodHours != other.retentionPeriodHours) return false
        if (streamArn != other.streamArn) return false
        if (streamCreationTimestamp != other.streamCreationTimestamp) return false
        if (streamModeDetails != other.streamModeDetails) return false
        if (streamName != other.streamName) return false
        if (streamStatus != other.streamStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.StreamDescriptionSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of enhanced fan-out consumers registered with the stream.
         */
        public var consumerCount: kotlin.Int? = null
        /**
         * The encryption type used. This value is one of the following:
         * + `KMS`
         * + `NONE`
         */
        public var encryptionType: aws.sdk.kotlin.services.kinesis.model.EncryptionType? = null
        /**
         * Represents the current enhanced monitoring settings of the stream.
         */
        public var enhancedMonitoring: List<EnhancedMetrics>? = null
        /**
         * The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias `aws/kinesis`.
         * + Key ARN example: `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
         * + Alias ARN example: ` arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
         * + Globally unique key ID example: `12345678-1234-1234-1234-123456789012`
         * + Alias name example: `alias/MyAliasName`
         * + Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
         */
        public var keyId: kotlin.String? = null
        /**
         * The number of open shards in the stream.
         */
        public var openShardCount: kotlin.Int? = null
        /**
         * The current retention period, in hours.
         */
        public var retentionPeriodHours: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the stream being described.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The approximate time that the stream was created.
         */
        public var streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** ycapacity mode and a **provisioned** capacity mode for your data streams.
         */
        public var streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = null
        /**
         * The name of the stream being described.
         */
        public var streamName: kotlin.String? = null
        /**
         * The current status of the stream being described. The stream status is one of the following states:
         * + `CREATING` - The stream is being created. Kinesis Data Streams immediately returns and sets `StreamStatus` to `CREATING`.
         * + `DELETING` - The stream is being deleted. The specified stream is in the `DELETING` state until Kinesis Data Streams completes the deletion.
         * + `ACTIVE` - The stream exists and is ready for read and write operations or deletion. You should perform read and write operations only on an `ACTIVE` stream.
         * + `UPDATING` - Shards in the stream are being merged or split. Read and write operations continue to work while the stream is in the `UPDATING` state.
         */
        public var streamStatus: aws.sdk.kotlin.services.kinesis.model.StreamStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.StreamDescriptionSummary) : this() {
            this.consumerCount = x.consumerCount
            this.encryptionType = x.encryptionType
            this.enhancedMonitoring = x.enhancedMonitoring
            this.keyId = x.keyId
            this.openShardCount = x.openShardCount
            this.retentionPeriodHours = x.retentionPeriodHours
            this.streamArn = x.streamArn
            this.streamCreationTimestamp = x.streamCreationTimestamp
            this.streamModeDetails = x.streamModeDetails
            this.streamName = x.streamName
            this.streamStatus = x.streamStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.StreamDescriptionSummary = StreamDescriptionSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.StreamModeDetails] inside the given [block]
         */
        public fun streamModeDetails(block: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.Builder.() -> kotlin.Unit) {
            this.streamModeDetails = aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (enhancedMonitoring == null) enhancedMonitoring = emptyList()
            if (openShardCount == null) openShardCount = 0
            if (retentionPeriodHours == null) retentionPeriodHours = 0
            if (streamArn == null) streamArn = ""
            if (streamCreationTimestamp == null) streamCreationTimestamp = Instant.fromEpochSeconds(0)
            if (streamName == null) streamName = ""
            if (streamStatus == null) streamStatus = StreamStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
