// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * A uniquely identified group of data records in a Kinesis data stream.
 */
public class Shard private constructor(builder: Builder) {
    /**
     * The shard ID of the shard adjacent to the shard's parent.
     */
    public val adjacentParentShardId: kotlin.String? = builder.adjacentParentShardId
    /**
     * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
     */
    public val hashKeyRange: aws.sdk.kotlin.services.kinesis.model.HashKeyRange? = builder.hashKeyRange
    /**
     * The shard ID of the shard's parent.
     */
    public val parentShardId: kotlin.String? = builder.parentShardId
    /**
     * The range of possible sequence numbers for the shard.
     */
    public val sequenceNumberRange: aws.sdk.kotlin.services.kinesis.model.SequenceNumberRange? = builder.sequenceNumberRange
    /**
     * The unique identifier of the shard within the stream.
     */
    public val shardId: kotlin.String = requireNotNull(builder.shardId) { "A non-null value must be provided for shardId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.Shard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Shard(")
        append("adjacentParentShardId=$adjacentParentShardId,")
        append("hashKeyRange=$hashKeyRange,")
        append("parentShardId=$parentShardId,")
        append("sequenceNumberRange=$sequenceNumberRange,")
        append("shardId=$shardId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjacentParentShardId?.hashCode() ?: 0
        result = 31 * result + (hashKeyRange?.hashCode() ?: 0)
        result = 31 * result + (parentShardId?.hashCode() ?: 0)
        result = 31 * result + (sequenceNumberRange?.hashCode() ?: 0)
        result = 31 * result + (shardId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Shard

        if (adjacentParentShardId != other.adjacentParentShardId) return false
        if (hashKeyRange != other.hashKeyRange) return false
        if (parentShardId != other.parentShardId) return false
        if (sequenceNumberRange != other.sequenceNumberRange) return false
        if (shardId != other.shardId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.Shard = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The shard ID of the shard adjacent to the shard's parent.
         */
        public var adjacentParentShardId: kotlin.String? = null
        /**
         * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
         */
        public var hashKeyRange: aws.sdk.kotlin.services.kinesis.model.HashKeyRange? = null
        /**
         * The shard ID of the shard's parent.
         */
        public var parentShardId: kotlin.String? = null
        /**
         * The range of possible sequence numbers for the shard.
         */
        public var sequenceNumberRange: aws.sdk.kotlin.services.kinesis.model.SequenceNumberRange? = null
        /**
         * The unique identifier of the shard within the stream.
         */
        public var shardId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.Shard) : this() {
            this.adjacentParentShardId = x.adjacentParentShardId
            this.hashKeyRange = x.hashKeyRange
            this.parentShardId = x.parentShardId
            this.sequenceNumberRange = x.sequenceNumberRange
            this.shardId = x.shardId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.Shard = Shard(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.HashKeyRange] inside the given [block]
         */
        public fun hashKeyRange(block: aws.sdk.kotlin.services.kinesis.model.HashKeyRange.Builder.() -> kotlin.Unit) {
            this.hashKeyRange = aws.sdk.kotlin.services.kinesis.model.HashKeyRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.SequenceNumberRange] inside the given [block]
         */
        public fun sequenceNumberRange(block: aws.sdk.kotlin.services.kinesis.model.SequenceNumberRange.Builder.() -> kotlin.Unit) {
            this.sequenceNumberRange = aws.sdk.kotlin.services.kinesis.model.SequenceNumberRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (shardId == null) shardId = ""
            return this
        }
    }
}
