// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents the output for `PutRecords`.
 */
public class PutRecordsRequestEntry private constructor(builder: Builder) {
    /**
     * The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The hash value used to determine explicitly the shard that the data record is assigned to by overriding the partition key hash.
     */
    public val explicitHashKey: kotlin.String? = builder.explicitHashKey
    /**
     * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
     */
    public val partitionKey: kotlin.String = requireNotNull(builder.partitionKey) { "A non-null value must be provided for partitionKey" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.PutRecordsRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecordsRequestEntry(")
        append("data=$data,")
        append("explicitHashKey=$explicitHashKey,")
        append("partitionKey=$partitionKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data.contentHashCode()
        result = 31 * result + (explicitHashKey?.hashCode() ?: 0)
        result = 31 * result + (partitionKey.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecordsRequestEntry

        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false
        if (explicitHashKey != other.explicitHashKey) return false
        if (partitionKey != other.partitionKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.PutRecordsRequestEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The hash value used to determine explicitly the shard that the data record is assigned to by overriding the partition key hash.
         */
        public var explicitHashKey: kotlin.String? = null
        /**
         * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
         */
        public var partitionKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.PutRecordsRequestEntry) : this() {
            this.data = x.data
            this.explicitHashKey = x.explicitHashKey
            this.partitionKey = x.partitionKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.PutRecordsRequestEntry = PutRecordsRequestEntry(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            if (partitionKey == null) partitionKey = ""
            return this
        }
    }
}
