// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents the output for GetRecords.
 */
public class GetRecordsResponse private constructor(builder: Builder) {
    /**
     * The list of the current shard's child shards, returned in the `GetRecords` API's response only when the end of the current shard is reached.
     */
    public val childShards: List<ChildShard>? = builder.childShards
    /**
     * The number of milliseconds the GetRecords response is from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.
     */
    public val millisBehindLatest: kotlin.Long? = builder.millisBehindLatest
    /**
     * The next position in the shard from which to start sequentially reading data records. If set to `null`, the shard has been closed and the requested iterator does not return any more data.
     */
    public val nextShardIterator: kotlin.String? = builder.nextShardIterator
    /**
     * The data records retrieved from the shard.
     */
    public val records: List<Record> = requireNotNull(builder.records) { "A non-null value must be provided for records" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecordsResponse(")
        append("childShards=$childShards,")
        append("millisBehindLatest=$millisBehindLatest,")
        append("nextShardIterator=$nextShardIterator,")
        append("records=$records")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childShards?.hashCode() ?: 0
        result = 31 * result + (millisBehindLatest?.hashCode() ?: 0)
        result = 31 * result + (nextShardIterator?.hashCode() ?: 0)
        result = 31 * result + (records.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecordsResponse

        if (childShards != other.childShards) return false
        if (millisBehindLatest != other.millisBehindLatest) return false
        if (nextShardIterator != other.nextShardIterator) return false
        if (records != other.records) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of the current shard's child shards, returned in the `GetRecords` API's response only when the end of the current shard is reached.
         */
        public var childShards: List<ChildShard>? = null
        /**
         * The number of milliseconds the GetRecords response is from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.
         */
        public var millisBehindLatest: kotlin.Long? = null
        /**
         * The next position in the shard from which to start sequentially reading data records. If set to `null`, the shard has been closed and the requested iterator does not return any more data.
         */
        public var nextShardIterator: kotlin.String? = null
        /**
         * The data records retrieved from the shard.
         */
        public var records: List<Record>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse) : this() {
            this.childShards = x.childShards
            this.millisBehindLatest = x.millisBehindLatest
            this.nextShardIterator = x.nextShardIterator
            this.records = x.records
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse = GetRecordsResponse(this)

        internal fun correctErrors(): Builder {
            if (records == null) records = emptyList()
            return this
        }
    }
}
