// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Output parameter of the GetRecords API. The existing child shard of the current shard.
 */
public class ChildShard private constructor(builder: Builder) {
    /**
     * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
     */
    public val hashKeyRange: aws.sdk.kotlin.services.kinesis.model.HashKeyRange? = builder.hashKeyRange
    /**
     * The current shard that is the parent of the existing child shard.
     */
    public val parentShards: List<String> = requireNotNull(builder.parentShards) { "A non-null value must be provided for parentShards" }
    /**
     * The shard ID of the existing child shard of the current shard.
     */
    public val shardId: kotlin.String = requireNotNull(builder.shardId) { "A non-null value must be provided for shardId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.ChildShard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChildShard(")
        append("hashKeyRange=$hashKeyRange,")
        append("parentShards=$parentShards,")
        append("shardId=$shardId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hashKeyRange?.hashCode() ?: 0
        result = 31 * result + (parentShards.hashCode())
        result = 31 * result + (shardId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChildShard

        if (hashKeyRange != other.hashKeyRange) return false
        if (parentShards != other.parentShards) return false
        if (shardId != other.shardId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.ChildShard = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
         */
        public var hashKeyRange: aws.sdk.kotlin.services.kinesis.model.HashKeyRange? = null
        /**
         * The current shard that is the parent of the existing child shard.
         */
        public var parentShards: List<String>? = null
        /**
         * The shard ID of the existing child shard of the current shard.
         */
        public var shardId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.ChildShard) : this() {
            this.hashKeyRange = x.hashKeyRange
            this.parentShards = x.parentShards
            this.shardId = x.shardId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.ChildShard = ChildShard(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.HashKeyRange] inside the given [block]
         */
        public fun hashKeyRange(block: aws.sdk.kotlin.services.kinesis.model.HashKeyRange.Builder.() -> kotlin.Unit) {
            this.hashKeyRange = aws.sdk.kotlin.services.kinesis.model.HashKeyRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (parentShards == null) parentShards = emptyList()
            if (shardId == null) shardId = ""
            return this
        }
    }
}
