// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.endpoints.internal

import aws.sdk.kotlin.services.kinesis.KinesisClient
import aws.sdk.kotlin.services.kinesis.endpoints.KinesisEndpointParameters
import aws.sdk.kotlin.services.kinesis.model.AddTagsToStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
import aws.sdk.kotlin.services.kinesis.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.kinesis.model.DeleteStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DeregisterStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamSummaryRequest
import aws.sdk.kotlin.services.kinesis.model.DisableEnhancedMonitoringRequest
import aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest
import aws.sdk.kotlin.services.kinesis.model.GetRecordsRequest
import aws.sdk.kotlin.services.kinesis.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest
import aws.sdk.kotlin.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
import aws.sdk.kotlin.services.kinesis.model.ListShardsRequest
import aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest
import aws.sdk.kotlin.services.kinesis.model.ListTagsForStreamRequest
import aws.sdk.kotlin.services.kinesis.model.MergeShardsRequest
import aws.sdk.kotlin.services.kinesis.model.PutRecordRequest
import aws.sdk.kotlin.services.kinesis.model.PutRecordsRequest
import aws.sdk.kotlin.services.kinesis.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.RemoveTagsFromStreamRequest
import aws.sdk.kotlin.services.kinesis.model.SplitShardRequest
import aws.sdk.kotlin.services.kinesis.model.StartStreamEncryptionRequest
import aws.sdk.kotlin.services.kinesis.model.StopStreamEncryptionRequest
import aws.sdk.kotlin.services.kinesis.model.SubscribeToShardRequest
import aws.sdk.kotlin.services.kinesis.model.UpdateShardCountRequest
import aws.sdk.kotlin.services.kinesis.model.UpdateStreamModeRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: KinesisClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: KinesisClient.Config, request: ResolveEndpointRequest): KinesisEndpointParameters {
    return KinesisEndpointParameters {
        bindAwsBuiltins(config, request)
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (KinesisEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "AddTagsToStream" to ::bindAddTagsToStreamEndpointContext,
    "DecreaseStreamRetentionPeriod" to ::bindDecreaseStreamRetentionPeriodEndpointContext,
    "DeleteResourcePolicy" to ::bindDeleteResourcePolicyEndpointContext,
    "DeleteStream" to ::bindDeleteStreamEndpointContext,
    "DeregisterStreamConsumer" to ::bindDeregisterStreamConsumerEndpointContext,
    "DescribeStream" to ::bindDescribeStreamEndpointContext,
    "DescribeStreamConsumer" to ::bindDescribeStreamConsumerEndpointContext,
    "DescribeStreamSummary" to ::bindDescribeStreamSummaryEndpointContext,
    "DisableEnhancedMonitoring" to ::bindDisableEnhancedMonitoringEndpointContext,
    "EnableEnhancedMonitoring" to ::bindEnableEnhancedMonitoringEndpointContext,
    "GetRecords" to ::bindGetRecordsEndpointContext,
    "GetResourcePolicy" to ::bindGetResourcePolicyEndpointContext,
    "GetShardIterator" to ::bindGetShardIteratorEndpointContext,
    "IncreaseStreamRetentionPeriod" to ::bindIncreaseStreamRetentionPeriodEndpointContext,
    "ListShards" to ::bindListShardsEndpointContext,
    "ListStreamConsumers" to ::bindListStreamConsumersEndpointContext,
    "ListTagsForStream" to ::bindListTagsForStreamEndpointContext,
    "MergeShards" to ::bindMergeShardsEndpointContext,
    "PutRecord" to ::bindPutRecordEndpointContext,
    "PutRecords" to ::bindPutRecordsEndpointContext,
    "PutResourcePolicy" to ::bindPutResourcePolicyEndpointContext,
    "RegisterStreamConsumer" to ::bindRegisterStreamConsumerEndpointContext,
    "RemoveTagsFromStream" to ::bindRemoveTagsFromStreamEndpointContext,
    "SplitShard" to ::bindSplitShardEndpointContext,
    "StartStreamEncryption" to ::bindStartStreamEncryptionEndpointContext,
    "StopStreamEncryption" to ::bindStopStreamEncryptionEndpointContext,
    "SubscribeToShard" to ::bindSubscribeToShardEndpointContext,
    "UpdateShardCount" to ::bindUpdateShardCountEndpointContext,
    "UpdateStreamMode" to ::bindUpdateStreamModeEndpointContext,
)

private fun KinesisEndpointParameters.Builder.bindAwsBuiltins(config: KinesisClient.Config, request: ResolveEndpointRequest) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}

private fun bindAddTagsToStreamEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as AddTagsToStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDecreaseStreamRetentionPeriodEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DecreaseStreamRetentionPeriodRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDeleteResourcePolicyEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteResourcePolicyRequest
    builder.operationType = "control"
    builder.resourceArn = input.resourceArn
}

private fun bindDeleteStreamEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDeregisterStreamConsumerEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeregisterStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
    builder.consumerArn = input.consumerArn
}

private fun bindDescribeStreamEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDescribeStreamConsumerEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
    builder.consumerArn = input.consumerArn
}

private fun bindDescribeStreamSummaryEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamSummaryRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDisableEnhancedMonitoringEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DisableEnhancedMonitoringRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindEnableEnhancedMonitoringEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as EnableEnhancedMonitoringRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindGetRecordsEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetRecordsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindGetResourcePolicyEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetResourcePolicyRequest
    builder.operationType = "control"
    builder.resourceArn = input.resourceArn
}

private fun bindGetShardIteratorEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetShardIteratorRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindIncreaseStreamRetentionPeriodEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as IncreaseStreamRetentionPeriodRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListShardsEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListShardsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListStreamConsumersEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListStreamConsumersRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListTagsForStreamEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListTagsForStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindMergeShardsEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as MergeShardsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindPutRecordEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutRecordRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindPutRecordsEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutRecordsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindPutResourcePolicyEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutResourcePolicyRequest
    builder.operationType = "control"
    builder.resourceArn = input.resourceArn
}

private fun bindRegisterStreamConsumerEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as RegisterStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindRemoveTagsFromStreamEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as RemoveTagsFromStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindSplitShardEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SplitShardRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindStartStreamEncryptionEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as StartStreamEncryptionRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindStopStreamEncryptionEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as StopStreamEncryptionRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindSubscribeToShardEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SubscribeToShardRequest
    builder.operationType = "data"
    builder.consumerArn = input.consumerArn
}

private fun bindUpdateShardCountEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateShardCountRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindUpdateStreamModeEndpointContext(builder: KinesisEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateStreamModeRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}
