// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.waiters

import aws.sdk.kotlin.services.kinesis.KinesisClient
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun KinesisClient.waitUntilStreamExists(request: DescribeStreamRequest): Outcome<DescribeStreamResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStreamRequest, DescribeStreamResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val streamDescription = it.streamDescription
            val streamStatus = streamDescription?.streamStatus?.value
            streamStatus == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStream(request) }
}

public suspend fun KinesisClient.waitUntilStreamExists(block: DescribeStreamRequest.Builder.() -> Unit): Outcome<DescribeStreamResponse> =
    waitUntilStreamExists(DescribeStreamRequest.Builder().apply(block).build())

public suspend fun KinesisClient.waitUntilStreamNotExists(request: DescribeStreamRequest): Outcome<DescribeStreamResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStreamRequest, DescribeStreamResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStream(request) }
}

public suspend fun KinesisClient.waitUntilStreamNotExists(block: DescribeStreamRequest.Builder.() -> Unit): Outcome<DescribeStreamResponse> =
    waitUntilStreamNotExists(DescribeStreamRequest.Builder().apply(block).build())
