// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.transform

import aws.sdk.kotlin.services.kinesis.model.EncryptionType
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.PutRecordsResponse
import aws.sdk.kotlin.services.kinesis.model.PutRecordsResultEntry
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutRecordsOperationDeserializer: HttpDeserialize<PutRecordsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutRecordsResponse {
        if (!response.status.isSuccess()) {
            throwPutRecordsError(context, response)
        }
        val builder = PutRecordsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutRecordsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutRecordsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedResponse)
        "KMSThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutRecordsOperationBody(builder: PutRecordsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EncryptionType"))
    val FAILEDRECORDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailedRecordCount"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENCRYPTIONTYPE_DESCRIPTOR)
        field(FAILEDRECORDCOUNT_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENCRYPTIONTYPE_DESCRIPTOR.index -> builder.encryptionType = deserializeString().let { EncryptionType.fromValue(it) }
                FAILEDRECORDCOUNT_DESCRIPTOR.index -> builder.failedRecordCount = deserializeInt()
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<PutRecordsResultEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePutRecordsResultEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
