// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.transform

import aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest
import aws.sdk.kotlin.services.kinesis.model.ShardIteratorType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetShardIteratorOperationSerializer: HttpSerialize<GetShardIteratorRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetShardIteratorRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeGetShardIteratorOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeGetShardIteratorOperationBody(context: ExecutionContext, input: GetShardIteratorRequest): ByteArray {
    val serializer = JsonSerializer()
    val SHARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ShardId"))
    val SHARDITERATORTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ShardIteratorType"))
    val STARTINGSEQUENCENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartingSequenceNumber"))
    val STREAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamARN"))
    val STREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamName"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Timestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SHARDID_DESCRIPTOR)
        field(SHARDITERATORTYPE_DESCRIPTOR)
        field(STARTINGSEQUENCENUMBER_DESCRIPTOR)
        field(STREAMARN_DESCRIPTOR)
        field(STREAMNAME_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.shardId?.let { field(SHARDID_DESCRIPTOR, it) }
        input.shardIteratorType?.let { field(SHARDITERATORTYPE_DESCRIPTOR, it.value) }
        input.startingSequenceNumber?.let { field(STARTINGSEQUENCENUMBER_DESCRIPTOR, it) }
        input.streamArn?.let { field(STREAMARN_DESCRIPTOR, it) }
        input.streamName?.let { field(STREAMNAME_DESCRIPTOR, it) }
        input.timestamp?.let { field(TIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
