// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.transform

import aws.sdk.kotlin.services.kinesis.model.DisableEnhancedMonitoringResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.MetricsName
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DisableEnhancedMonitoringOperationDeserializer: HttpDeserialize<DisableEnhancedMonitoringResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisableEnhancedMonitoringResponse {
        if (!response.status.isSuccess()) {
            throwDisableEnhancedMonitoringError(context, response)
        }
        val builder = DisableEnhancedMonitoringResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisableEnhancedMonitoringOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisableEnhancedMonitoringError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisableEnhancedMonitoringOperationBody(builder: DisableEnhancedMonitoringResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CURRENTSHARDLEVELMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CurrentShardLevelMetrics"))
    val DESIREDSHARDLEVELMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DesiredShardLevelMetrics"))
    val STREAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamARN"))
    val STREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTSHARDLEVELMETRICS_DESCRIPTOR)
        field(DESIREDSHARDLEVELMETRICS_DESCRIPTOR)
        field(STREAMARN_DESCRIPTOR)
        field(STREAMNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENTSHARDLEVELMETRICS_DESCRIPTOR.index -> builder.currentShardLevelMetrics =
                    deserializer.deserializeList(CURRENTSHARDLEVELMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricsName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { MetricsName.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESIREDSHARDLEVELMETRICS_DESCRIPTOR.index -> builder.desiredShardLevelMetrics =
                    deserializer.deserializeList(DESIREDSHARDLEVELMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricsName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { MetricsName.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STREAMARN_DESCRIPTOR.index -> builder.streamArn = deserializeString()
                STREAMNAME_DESCRIPTOR.index -> builder.streamName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
