// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents the input for `SplitShard`.
 */
public class SplitShardRequest private constructor(builder: Builder) {
    /**
     * A hash key value for the starting hash key of one of the child shards created by the split. The hash key range for a given shard constitutes a set of ordered contiguous positive integers. The value for `NewStartingHashKey` must be in the range of hash keys being mapped into the shard. The `NewStartingHashKey` hash key value and all higher hash key values in hash key range are distributed to one of the child shards. All the lower hash key values in the range are distributed to the other child shard.
     */
    public val newStartingHashKey: kotlin.String? = builder.newStartingHashKey
    /**
     * The shard ID of the shard to split.
     */
    public val shardToSplit: kotlin.String? = builder.shardToSplit
    /**
     * The ARN of the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream for the shard split.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.SplitShardRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SplitShardRequest(")
        append("newStartingHashKey=$newStartingHashKey,")
        append("shardToSplit=$shardToSplit,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = newStartingHashKey?.hashCode() ?: 0
        result = 31 * result + (shardToSplit?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SplitShardRequest

        if (newStartingHashKey != other.newStartingHashKey) return false
        if (shardToSplit != other.shardToSplit) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.SplitShardRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A hash key value for the starting hash key of one of the child shards created by the split. The hash key range for a given shard constitutes a set of ordered contiguous positive integers. The value for `NewStartingHashKey` must be in the range of hash keys being mapped into the shard. The `NewStartingHashKey` hash key value and all higher hash key values in hash key range are distributed to one of the child shards. All the lower hash key values in the range are distributed to the other child shard.
         */
        public var newStartingHashKey: kotlin.String? = null
        /**
         * The shard ID of the shard to split.
         */
        public var shardToSplit: kotlin.String? = null
        /**
         * The ARN of the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The name of the stream for the shard split.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.SplitShardRequest) : this() {
            this.newStartingHashKey = x.newStartingHashKey
            this.shardToSplit = x.shardToSplit
            this.streamArn = x.streamArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.SplitShardRequest = SplitShardRequest(this)
    }
}
