// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



public class RegisterStreamConsumerRequest private constructor(builder: Builder) {
    /**
     * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to be unique across data streams.
     */
    public val consumerName: kotlin.String? = builder.consumerName
    /**
     * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
     */
    public val streamArn: kotlin.String? = builder.streamArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterStreamConsumerRequest(")
        append("consumerName=$consumerName,")
        append("streamArn=$streamArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerName?.hashCode() ?: 0
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterStreamConsumerRequest

        if (consumerName != other.consumerName) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to be unique across data streams.
         */
        public var consumerName: kotlin.String? = null
        /**
         * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
         */
        public var streamArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest) : this() {
            this.consumerName = x.consumerName
            this.streamArn = x.streamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest = RegisterStreamConsumerRequest(this)
    }
}
