// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents the result of an individual record from a `PutRecords` request. A record that is successfully added to a stream includes `SequenceNumber` and `ShardId` in the result. A record that fails to be added to the stream includes `ErrorCode` and `ErrorMessage` in the result.
 */
public class PutRecordsResultEntry private constructor(builder: Builder) {
    /**
     * The error code for an individual record result. `ErrorCodes` can be either `ProvisionedThroughputExceededException` or `InternalFailure`.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The error message for an individual record result. An `ErrorCode` value of `ProvisionedThroughputExceededException` has an error message that includes the account ID, stream name, and shard ID. An `ErrorCode` value of `InternalFailure` has the error message `"Internal Service Failure"`.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The sequence number for an individual record result.
     */
    public val sequenceNumber: kotlin.String? = builder.sequenceNumber
    /**
     * The shard ID for an individual record result.
     */
    public val shardId: kotlin.String? = builder.shardId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.PutRecordsResultEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecordsResultEntry(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("sequenceNumber=$sequenceNumber,")
        append("shardId=$shardId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (sequenceNumber?.hashCode() ?: 0)
        result = 31 * result + (shardId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecordsResultEntry

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (sequenceNumber != other.sequenceNumber) return false
        if (shardId != other.shardId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.PutRecordsResultEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The error code for an individual record result. `ErrorCodes` can be either `ProvisionedThroughputExceededException` or `InternalFailure`.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message for an individual record result. An `ErrorCode` value of `ProvisionedThroughputExceededException` has an error message that includes the account ID, stream name, and shard ID. An `ErrorCode` value of `InternalFailure` has the error message `"Internal Service Failure"`.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The sequence number for an individual record result.
         */
        public var sequenceNumber: kotlin.String? = null
        /**
         * The shard ID for an individual record result.
         */
        public var shardId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.PutRecordsResultEntry) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.sequenceNumber = x.sequenceNumber
            this.shardId = x.shardId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.PutRecordsResultEntry = PutRecordsResultEntry(this)
    }
}
