// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListStreamConsumersRequest private constructor(builder: Builder) {
    /**
     * The maximum number of consumers that you want a single call of `ListStreamConsumers` to return. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of consumers that are registered with the data stream is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of consumers that are registered with the data stream, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListStreamConsumers` to list the next set of registered consumers.
     *
     * Don't specify `StreamName` or `StreamCreationTimestamp` if you specify `NextToken` because the latter unambiguously identifies the stream.
     *
     * You can optionally specify a value for the `MaxResults` parameter when you specify `NextToken`. If you specify a `MaxResults` value that is less than the number of consumers that the operation returns if you don't specify `MaxResults`, the response will contain a new `NextToken` value. You can use the new `NextToken` value in a subsequent call to the `ListStreamConsumers` operation to list the next set of consumers.
     *
     * Tokens expire after 300 seconds. When you obtain a value for `NextToken` in the response to a call to `ListStreamConsumers`, you have 300 seconds to use that value. If you specify an expired token in a call to `ListStreamConsumers`, you get `ExpiredNextTokenException`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the consumers for.
     *
     * You can't specify this parameter if you specify the NextToken parameter.
     */
    public val streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.streamCreationTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStreamConsumersRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("streamArn=$streamArn,")
        append("streamCreationTimestamp=$streamCreationTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamCreationTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStreamConsumersRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (streamArn != other.streamArn) return false
        if (streamCreationTimestamp != other.streamCreationTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of consumers that you want a single call of `ListStreamConsumers` to return. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of consumers that are registered with the data stream is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of consumers that are registered with the data stream, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListStreamConsumers` to list the next set of registered consumers.
         *
         * Don't specify `StreamName` or `StreamCreationTimestamp` if you specify `NextToken` because the latter unambiguously identifies the stream.
         *
         * You can optionally specify a value for the `MaxResults` parameter when you specify `NextToken`. If you specify a `MaxResults` value that is less than the number of consumers that the operation returns if you don't specify `MaxResults`, the response will contain a new `NextToken` value. You can use the new `NextToken` value in a subsequent call to the `ListStreamConsumers` operation to list the next set of consumers.
         *
         * Tokens expire after 300 seconds. When you obtain a value for `NextToken` in the response to a call to `ListStreamConsumers`, you have 300 seconds to use that value. If you specify an expired token in a call to `ListStreamConsumers`, you get `ExpiredNextTokenException`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
         */
        public var streamArn: kotlin.String? = null
        /**
         * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the consumers for.
         *
         * You can't specify this parameter if you specify the NextToken parameter.
         */
        public var streamCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.streamArn = x.streamArn
            this.streamCreationTimestamp = x.streamCreationTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest = ListStreamConsumersRequest(this)
    }
}
