// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents the details of the consumer you registered. This type of object is returned by RegisterStreamConsumer.
 */
public class Consumer private constructor(builder: Builder) {
    /**
     * When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be able to call SubscribeToShard.
     *
     * If you delete a consumer and then create a new one with the same name, it won't have the same ARN. That's because consumer ARNs contain the creation timestamp. This is important to keep in mind if you have IAM policies that reference consumer ARNs.
     */
    public val consumerArn: kotlin.String? = builder.consumerArn
    /**
     *
     */
    public val consumerCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.consumerCreationTimestamp
    /**
     * The name of the consumer is something you choose when you register the consumer.
     */
    public val consumerName: kotlin.String? = builder.consumerName
    /**
     * A consumer can't read data while in the `CREATING` or `DELETING` states.
     */
    public val consumerStatus: aws.sdk.kotlin.services.kinesis.model.ConsumerStatus? = builder.consumerStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.Consumer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Consumer(")
        append("consumerArn=$consumerArn,")
        append("consumerCreationTimestamp=$consumerCreationTimestamp,")
        append("consumerName=$consumerName,")
        append("consumerStatus=$consumerStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerArn?.hashCode() ?: 0
        result = 31 * result + (consumerCreationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (consumerName?.hashCode() ?: 0)
        result = 31 * result + (consumerStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Consumer

        if (consumerArn != other.consumerArn) return false
        if (consumerCreationTimestamp != other.consumerCreationTimestamp) return false
        if (consumerName != other.consumerName) return false
        if (consumerStatus != other.consumerStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.Consumer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When you register a consumer, Kinesis Data Streams generates an ARN for it. You need this ARN to be able to call SubscribeToShard.
         *
         * If you delete a consumer and then create a new one with the same name, it won't have the same ARN. That's because consumer ARNs contain the creation timestamp. This is important to keep in mind if you have IAM policies that reference consumer ARNs.
         */
        public var consumerArn: kotlin.String? = null
        /**
         *
         */
        public var consumerCreationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the consumer is something you choose when you register the consumer.
         */
        public var consumerName: kotlin.String? = null
        /**
         * A consumer can't read data while in the `CREATING` or `DELETING` states.
         */
        public var consumerStatus: aws.sdk.kotlin.services.kinesis.model.ConsumerStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.Consumer) : this() {
            this.consumerArn = x.consumerArn
            this.consumerCreationTimestamp = x.consumerCreationTimestamp
            this.consumerName = x.consumerName
            this.consumerStatus = x.consumerStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.Consumer = Consumer(this)
    }
}
