// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.endpoints.internal

import aws.sdk.kotlin.services.kinesis.KinesisClient
import aws.sdk.kotlin.services.kinesis.endpoints.EndpointParameters
import aws.sdk.kotlin.services.kinesis.model.AddTagsToStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
import aws.sdk.kotlin.services.kinesis.model.DeleteStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DeregisterStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamRequest
import aws.sdk.kotlin.services.kinesis.model.DescribeStreamSummaryRequest
import aws.sdk.kotlin.services.kinesis.model.DisableEnhancedMonitoringRequest
import aws.sdk.kotlin.services.kinesis.model.EnableEnhancedMonitoringRequest
import aws.sdk.kotlin.services.kinesis.model.GetRecordsRequest
import aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest
import aws.sdk.kotlin.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
import aws.sdk.kotlin.services.kinesis.model.ListShardsRequest
import aws.sdk.kotlin.services.kinesis.model.ListStreamConsumersRequest
import aws.sdk.kotlin.services.kinesis.model.ListTagsForStreamRequest
import aws.sdk.kotlin.services.kinesis.model.MergeShardsRequest
import aws.sdk.kotlin.services.kinesis.model.PutRecordRequest
import aws.sdk.kotlin.services.kinesis.model.PutRecordsRequest
import aws.sdk.kotlin.services.kinesis.model.RegisterStreamConsumerRequest
import aws.sdk.kotlin.services.kinesis.model.RemoveTagsFromStreamRequest
import aws.sdk.kotlin.services.kinesis.model.SplitShardRequest
import aws.sdk.kotlin.services.kinesis.model.StartStreamEncryptionRequest
import aws.sdk.kotlin.services.kinesis.model.StopStreamEncryptionRequest
import aws.sdk.kotlin.services.kinesis.model.UpdateShardCountRequest
import aws.sdk.kotlin.services.kinesis.model.UpdateStreamModeRequest
import aws.smithy.kotlin.runtime.auth.awssigning.mergeInto
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.signingContext
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: KinesisClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = EndpointParameters {
            bindAwsBuiltins(config)
            val opName = request.context[SdkClientOption.OperationName]
            opContextBindings[opName]?.invoke(this, request)
        }
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        endpoint.signingContext?.mergeInto(request.context)
        return endpoint
    }
}

private typealias BindOperationContextParamsFn = (EndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "AddTagsToStream" to ::bindAddTagsToStreamEndpointContext,
    "DecreaseStreamRetentionPeriod" to ::bindDecreaseStreamRetentionPeriodEndpointContext,
    "DeleteStream" to ::bindDeleteStreamEndpointContext,
    "DeregisterStreamConsumer" to ::bindDeregisterStreamConsumerEndpointContext,
    "DescribeStream" to ::bindDescribeStreamEndpointContext,
    "DescribeStreamConsumer" to ::bindDescribeStreamConsumerEndpointContext,
    "DescribeStreamSummary" to ::bindDescribeStreamSummaryEndpointContext,
    "DisableEnhancedMonitoring" to ::bindDisableEnhancedMonitoringEndpointContext,
    "EnableEnhancedMonitoring" to ::bindEnableEnhancedMonitoringEndpointContext,
    "GetRecords" to ::bindGetRecordsEndpointContext,
    "GetShardIterator" to ::bindGetShardIteratorEndpointContext,
    "IncreaseStreamRetentionPeriod" to ::bindIncreaseStreamRetentionPeriodEndpointContext,
    "ListShards" to ::bindListShardsEndpointContext,
    "ListStreamConsumers" to ::bindListStreamConsumersEndpointContext,
    "ListTagsForStream" to ::bindListTagsForStreamEndpointContext,
    "MergeShards" to ::bindMergeShardsEndpointContext,
    "PutRecord" to ::bindPutRecordEndpointContext,
    "PutRecords" to ::bindPutRecordsEndpointContext,
    "RegisterStreamConsumer" to ::bindRegisterStreamConsumerEndpointContext,
    "RemoveTagsFromStream" to ::bindRemoveTagsFromStreamEndpointContext,
    "SplitShard" to ::bindSplitShardEndpointContext,
    "StartStreamEncryption" to ::bindStartStreamEncryptionEndpointContext,
    "StopStreamEncryption" to ::bindStopStreamEncryptionEndpointContext,
    "UpdateShardCount" to ::bindUpdateShardCountEndpointContext,
    "UpdateStreamMode" to ::bindUpdateStreamModeEndpointContext,
)

private fun EndpointParameters.Builder.bindAwsBuiltins(config: KinesisClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}

private fun bindAddTagsToStreamEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as AddTagsToStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDecreaseStreamRetentionPeriodEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DecreaseStreamRetentionPeriodRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDeleteStreamEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeleteStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDeregisterStreamConsumerEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DeregisterStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
    builder.consumerArn = input.consumerArn
}

private fun bindDescribeStreamEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDescribeStreamConsumerEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
    builder.consumerArn = input.consumerArn
}

private fun bindDescribeStreamSummaryEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DescribeStreamSummaryRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindDisableEnhancedMonitoringEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as DisableEnhancedMonitoringRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindEnableEnhancedMonitoringEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as EnableEnhancedMonitoringRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindGetRecordsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetRecordsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindGetShardIteratorEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as GetShardIteratorRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindIncreaseStreamRetentionPeriodEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as IncreaseStreamRetentionPeriodRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListShardsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListShardsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListStreamConsumersEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListStreamConsumersRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindListTagsForStreamEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as ListTagsForStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindMergeShardsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as MergeShardsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindPutRecordEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutRecordRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindPutRecordsEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutRecordsRequest
    builder.streamArn = input.streamArn
    builder.operationType = "data"
}

private fun bindRegisterStreamConsumerEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as RegisterStreamConsumerRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindRemoveTagsFromStreamEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as RemoveTagsFromStreamRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindSplitShardEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as SplitShardRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindStartStreamEncryptionEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as StartStreamEncryptionRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindStopStreamEncryptionEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as StopStreamEncryptionRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindUpdateShardCountEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateShardCountRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}

private fun bindUpdateStreamModeEndpointContext(builder: EndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as UpdateStreamModeRequest
    builder.streamArn = input.streamArn
    builder.operationType = "control"
}
