// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.keyspaces.model.GetKeyspaceResponse
import aws.sdk.kotlin.services.keyspaces.model.KeyspacesException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetKeyspaceOperationDeserializer: HttpDeserialize<GetKeyspaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetKeyspaceResponse {
        if (!response.status.isSuccess()) {
            throwGetKeyspaceError(context, response)
        }
        val builder = GetKeyspaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetKeyspaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetKeyspaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KeyspacesException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KeyspacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetKeyspaceOperationBody(builder: GetKeyspaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYSPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("keyspaceName"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYSPACENAME_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYSPACENAME_DESCRIPTOR.index -> builder.keyspaceName = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
