// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.paginators

import aws.sdk.kotlin.services.keyspaces.KeyspacesClient
import aws.sdk.kotlin.services.keyspaces.model.KeyspaceSummary
import aws.sdk.kotlin.services.keyspaces.model.ListKeyspacesRequest
import aws.sdk.kotlin.services.keyspaces.model.ListKeyspacesResponse
import aws.sdk.kotlin.services.keyspaces.model.ListTablesRequest
import aws.sdk.kotlin.services.keyspaces.model.ListTablesResponse
import aws.sdk.kotlin.services.keyspaces.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.keyspaces.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.keyspaces.model.TableSummary
import aws.sdk.kotlin.services.keyspaces.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListKeyspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeyspacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyspacesResponse]
 */
fun KeyspacesClient.listKeyspacesPaginated(initialRequest: ListKeyspacesRequest): Flow<ListKeyspacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKeyspacesPaginated.listKeyspaces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListKeyspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyspacesResponse]
 */
fun KeyspacesClient.listKeyspacesPaginated(block: ListKeyspacesRequest.Builder.() -> Unit): Flow<ListKeyspacesResponse> =
    listKeyspacesPaginated(ListKeyspacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeyspacesPaginated]
 * to access the nested member [KeyspaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KeyspaceSummary]
 */
@JvmName("listKeyspacesResponseKeyspaceSummary")
fun Flow<ListKeyspacesResponse>.keyspaces(): Flow<KeyspaceSummary> =
    transform() { response ->
        response.keyspaces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun KeyspacesClient.listTablesPaginated(initialRequest: ListTablesRequest): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
fun KeyspacesClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTablesPaginated]
 * to access the nested member [TableSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableSummary]
 */
@JvmName("listTablesResponseTableSummary")
fun Flow<ListTablesResponse>.tables(): Flow<TableSummary> =
    transform() { response ->
        response.tables?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun KeyspacesClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun KeyspacesClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
