// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model



class UpdateTableRequest private constructor(builder: Builder) {
    /**
     * For each column to be added to the specified table:
     *
     * • `name` - The name of the column.
     *
     * • `type` - An Amazon Keyspaces data type. For more information, see [Data types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types) in the *Amazon Keyspaces Developer Guide*.
     */
    val addColumns: List<ColumnDefinition>? = builder.addColumns
    /**
     * Modifies the read/write throughput capacity mode for the table. The options are:
     *
     * • `throughputMode:PAY_PER_REQUEST` and
     *
     * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
     *
     * The default is `throughput_mode:PAY_PER_REQUEST`.
     *
     * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val capacitySpecification: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = builder.capacitySpecification
    /**
     * The default Time to Live setting in seconds for the table.
     *
     * For more information, see [Setting the default TTL value for a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl) in the *Amazon Keyspaces Developer Guide*.
     */
    val defaultTimeToLive: kotlin.Int? = builder.defaultTimeToLive
    /**
     * Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):
     *
     * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
     *
     * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
     *
     * The default is `AWS_OWNED_KMS_KEY`.
     *
     * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val encryptionSpecification: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = builder.encryptionSpecification
    /**
     * The name of the keyspace the specified table is stored in.
     */
    val keyspaceName: kotlin.String? = builder.keyspaceName
    /**
     * Modifies the `pointInTimeRecovery` settings of the table. The options are:
     *
     * • `ENABLED`
     *
     * • `DISABLED`
     *
     * If it's not specified, the default is `DISABLED`.
     *
     * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val pointInTimeRecovery: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = builder.pointInTimeRecovery
    /**
     * The name of the table.
     */
    val tableName: kotlin.String? = builder.tableName
    /**
     * Modifies Time to Live custom settings for the table. The options are:
     *
     * • `status:enabled`
     *
     * • `status:disabled`
     *
     * The default is `status:disabled`. After `ttl` is enabled, you can't disable it for the table.
     *
     * For more information, see [Expiring data by using Amazon Keyspaces Time to Live (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val ttl: aws.sdk.kotlin.services.keyspaces.model.TimeToLive? = builder.ttl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.UpdateTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTableRequest(")
        append("addColumns=$addColumns,")
        append("capacitySpecification=$capacitySpecification,")
        append("defaultTimeToLive=$defaultTimeToLive,")
        append("encryptionSpecification=$encryptionSpecification,")
        append("keyspaceName=$keyspaceName,")
        append("pointInTimeRecovery=$pointInTimeRecovery,")
        append("tableName=$tableName,")
        append("ttl=$ttl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addColumns?.hashCode() ?: 0
        result = 31 * result + (capacitySpecification?.hashCode() ?: 0)
        result = 31 * result + (defaultTimeToLive ?: 0)
        result = 31 * result + (encryptionSpecification?.hashCode() ?: 0)
        result = 31 * result + (keyspaceName?.hashCode() ?: 0)
        result = 31 * result + (pointInTimeRecovery?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTableRequest

        if (addColumns != other.addColumns) return false
        if (capacitySpecification != other.capacitySpecification) return false
        if (defaultTimeToLive != other.defaultTimeToLive) return false
        if (encryptionSpecification != other.encryptionSpecification) return false
        if (keyspaceName != other.keyspaceName) return false
        if (pointInTimeRecovery != other.pointInTimeRecovery) return false
        if (tableName != other.tableName) return false
        if (ttl != other.ttl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.UpdateTableRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * For each column to be added to the specified table:
         *
         * • `name` - The name of the column.
         *
         * • `type` - An Amazon Keyspaces data type. For more information, see [Data types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types) in the *Amazon Keyspaces Developer Guide*.
         */
        var addColumns: List<ColumnDefinition>? = null
        /**
         * Modifies the read/write throughput capacity mode for the table. The options are:
         *
         * • `throughputMode:PAY_PER_REQUEST` and
         *
         * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
         *
         * The default is `throughput_mode:PAY_PER_REQUEST`.
         *
         * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var capacitySpecification: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = null
        /**
         * The default Time to Live setting in seconds for the table.
         *
         * For more information, see [Setting the default TTL value for a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl) in the *Amazon Keyspaces Developer Guide*.
         */
        var defaultTimeToLive: kotlin.Int? = null
        /**
         * Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):
         *
         * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
         *
         * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
         *
         * The default is `AWS_OWNED_KMS_KEY`.
         *
         * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var encryptionSpecification: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = null
        /**
         * The name of the keyspace the specified table is stored in.
         */
        var keyspaceName: kotlin.String? = null
        /**
         * Modifies the `pointInTimeRecovery` settings of the table. The options are:
         *
         * • `ENABLED`
         *
         * • `DISABLED`
         *
         * If it's not specified, the default is `DISABLED`.
         *
         * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var pointInTimeRecovery: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = null
        /**
         * The name of the table.
         */
        var tableName: kotlin.String? = null
        /**
         * Modifies Time to Live custom settings for the table. The options are:
         *
         * • `status:enabled`
         *
         * • `status:disabled`
         *
         * The default is `status:disabled`. After `ttl` is enabled, you can't disable it for the table.
         *
         * For more information, see [Expiring data by using Amazon Keyspaces Time to Live (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var ttl: aws.sdk.kotlin.services.keyspaces.model.TimeToLive? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.UpdateTableRequest) : this() {
            this.addColumns = x.addColumns
            this.capacitySpecification = x.capacitySpecification
            this.defaultTimeToLive = x.defaultTimeToLive
            this.encryptionSpecification = x.encryptionSpecification
            this.keyspaceName = x.keyspaceName
            this.pointInTimeRecovery = x.pointInTimeRecovery
            this.tableName = x.tableName
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.UpdateTableRequest = UpdateTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification] inside the given [block]
         */
        fun capacitySpecification(block: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.Builder.() -> kotlin.Unit) {
            this.capacitySpecification = aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification] inside the given [block]
         */
        fun encryptionSpecification(block: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.Builder.() -> kotlin.Unit) {
            this.encryptionSpecification = aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery] inside the given [block]
         */
        fun pointInTimeRecovery(block: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.Builder.() -> kotlin.Unit) {
            this.pointInTimeRecovery = aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.TimeToLive] inside the given [block]
         */
        fun ttl(block: aws.sdk.kotlin.services.keyspaces.model.TimeToLive.Builder.() -> kotlin.Unit) {
            this.ttl = aws.sdk.kotlin.services.keyspaces.model.TimeToLive.invoke(block)
        }
    }
}
