// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model



class CreateTableRequest private constructor(builder: Builder) {
    /**
     * Specifies the read/write throughput capacity mode for the table. The options are:
     *
     * • `throughputMode:PAY_PER_REQUEST` and
     *
     * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
     *
     * The default is `throughput_mode:PAY_PER_REQUEST`.
     *
     * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val capacitySpecification: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = builder.capacitySpecification
    /**
     * This parameter allows to enter a description of the table.
     */
    val comment: aws.sdk.kotlin.services.keyspaces.model.Comment? = builder.comment
    /**
     * The default Time to Live setting in seconds for the table.
     *
     * For more information, see [Setting the default TTL value for a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl) in the *Amazon Keyspaces Developer Guide*.
     */
    val defaultTimeToLive: kotlin.Int? = builder.defaultTimeToLive
    /**
     * Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):
     *
     * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
     *
     * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
     *
     * The default is `type:AWS_OWNED_KMS_KEY`.
     *
     * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val encryptionSpecification: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = builder.encryptionSpecification
    /**
     * The name of the keyspace that the table is going to be created in.
     */
    val keyspaceName: kotlin.String? = builder.keyspaceName
    /**
     * Specifies if `pointInTimeRecovery` is enabled or disabled for the table. The options are:
     *
     * • `ENABLED`
     *
     * • `DISABLED`
     *
     * If it's not specified, the default is `DISABLED`.
     *
     * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val pointInTimeRecovery: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = builder.pointInTimeRecovery
    /**
     * The `schemaDefinition` consists of the following parameters.
     *
     * For each column to be created:
     *
     * • `name` - The name of the column.
     *
     * • `type` - An Amazon Keyspaces data type. For more information, see [Data types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types) in the *Amazon Keyspaces Developer Guide*.
     *
     * The primary key of the table consists of the following columns:
     *
     * • `partitionKeys` - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.
     *
     * • `name` - The name of each partition key column.
     *
     * • `clusteringKeys` - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.
     *
     * • `name` - The name of the clustering column.
     *
     * • `orderBy` - Sets the ascendant (`ASC`) or descendant (`DESC`) order modifier.
     *
     * To define a column as static use `staticColumns` - Static columns store values that are shared by all rows in the same partition:
     *
     * • `name` - The name of the column.
     *
     * • `type` - An Amazon Keyspaces data type.
     */
    val schemaDefinition: aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition? = builder.schemaDefinition
    /**
     * The name of the table.
     */
    val tableName: kotlin.String? = builder.tableName
    /**
     * A list of key-value pair tags to be attached to the resource.
     *
     * For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Enables Time to Live custom settings for the table. The options are:
     *
     * • `status:enabled`
     *
     * • `status:disabled`
     *
     * The default is `status:disabled`. After `ttl` is enabled, you can't disable it for the table.
     *
     * For more information, see [Expiring data by using Amazon Keyspaces Time to Live (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val ttl: aws.sdk.kotlin.services.keyspaces.model.TimeToLive? = builder.ttl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.CreateTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTableRequest(")
        append("capacitySpecification=$capacitySpecification,")
        append("comment=$comment,")
        append("defaultTimeToLive=$defaultTimeToLive,")
        append("encryptionSpecification=$encryptionSpecification,")
        append("keyspaceName=$keyspaceName,")
        append("pointInTimeRecovery=$pointInTimeRecovery,")
        append("schemaDefinition=$schemaDefinition,")
        append("tableName=$tableName,")
        append("tags=$tags,")
        append("ttl=$ttl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacitySpecification?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (defaultTimeToLive ?: 0)
        result = 31 * result + (encryptionSpecification?.hashCode() ?: 0)
        result = 31 * result + (keyspaceName?.hashCode() ?: 0)
        result = 31 * result + (pointInTimeRecovery?.hashCode() ?: 0)
        result = 31 * result + (schemaDefinition?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTableRequest

        if (capacitySpecification != other.capacitySpecification) return false
        if (comment != other.comment) return false
        if (defaultTimeToLive != other.defaultTimeToLive) return false
        if (encryptionSpecification != other.encryptionSpecification) return false
        if (keyspaceName != other.keyspaceName) return false
        if (pointInTimeRecovery != other.pointInTimeRecovery) return false
        if (schemaDefinition != other.schemaDefinition) return false
        if (tableName != other.tableName) return false
        if (tags != other.tags) return false
        if (ttl != other.ttl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.CreateTableRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the read/write throughput capacity mode for the table. The options are:
         *
         * • `throughputMode:PAY_PER_REQUEST` and
         *
         * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
         *
         * The default is `throughput_mode:PAY_PER_REQUEST`.
         *
         * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var capacitySpecification: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = null
        /**
         * This parameter allows to enter a description of the table.
         */
        var comment: aws.sdk.kotlin.services.keyspaces.model.Comment? = null
        /**
         * The default Time to Live setting in seconds for the table.
         *
         * For more information, see [Setting the default TTL value for a table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl) in the *Amazon Keyspaces Developer Guide*.
         */
        var defaultTimeToLive: kotlin.Int? = null
        /**
         * Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):
         *
         * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
         *
         * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
         *
         * The default is `type:AWS_OWNED_KMS_KEY`.
         *
         * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var encryptionSpecification: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = null
        /**
         * The name of the keyspace that the table is going to be created in.
         */
        var keyspaceName: kotlin.String? = null
        /**
         * Specifies if `pointInTimeRecovery` is enabled or disabled for the table. The options are:
         *
         * • `ENABLED`
         *
         * • `DISABLED`
         *
         * If it's not specified, the default is `DISABLED`.
         *
         * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var pointInTimeRecovery: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = null
        /**
         * The `schemaDefinition` consists of the following parameters.
         *
         * For each column to be created:
         *
         * • `name` - The name of the column.
         *
         * • `type` - An Amazon Keyspaces data type. For more information, see [Data types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types) in the *Amazon Keyspaces Developer Guide*.
         *
         * The primary key of the table consists of the following columns:
         *
         * • `partitionKeys` - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.
         *
         * • `name` - The name of each partition key column.
         *
         * • `clusteringKeys` - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.
         *
         * • `name` - The name of the clustering column.
         *
         * • `orderBy` - Sets the ascendant (`ASC`) or descendant (`DESC`) order modifier.
         *
         * To define a column as static use `staticColumns` - Static columns store values that are shared by all rows in the same partition:
         *
         * • `name` - The name of the column.
         *
         * • `type` - An Amazon Keyspaces data type.
         */
        var schemaDefinition: aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition? = null
        /**
         * The name of the table.
         */
        var tableName: kotlin.String? = null
        /**
         * A list of key-value pair tags to be attached to the resource.
         *
         * For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var tags: List<Tag>? = null
        /**
         * Enables Time to Live custom settings for the table. The options are:
         *
         * • `status:enabled`
         *
         * • `status:disabled`
         *
         * The default is `status:disabled`. After `ttl` is enabled, you can't disable it for the table.
         *
         * For more information, see [Expiring data by using Amazon Keyspaces Time to Live (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var ttl: aws.sdk.kotlin.services.keyspaces.model.TimeToLive? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.CreateTableRequest) : this() {
            this.capacitySpecification = x.capacitySpecification
            this.comment = x.comment
            this.defaultTimeToLive = x.defaultTimeToLive
            this.encryptionSpecification = x.encryptionSpecification
            this.keyspaceName = x.keyspaceName
            this.pointInTimeRecovery = x.pointInTimeRecovery
            this.schemaDefinition = x.schemaDefinition
            this.tableName = x.tableName
            this.tags = x.tags
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.CreateTableRequest = CreateTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification] inside the given [block]
         */
        fun capacitySpecification(block: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.Builder.() -> kotlin.Unit) {
            this.capacitySpecification = aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.Comment] inside the given [block]
         */
        fun comment(block: aws.sdk.kotlin.services.keyspaces.model.Comment.Builder.() -> kotlin.Unit) {
            this.comment = aws.sdk.kotlin.services.keyspaces.model.Comment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification] inside the given [block]
         */
        fun encryptionSpecification(block: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.Builder.() -> kotlin.Unit) {
            this.encryptionSpecification = aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery] inside the given [block]
         */
        fun pointInTimeRecovery(block: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.Builder.() -> kotlin.Unit) {
            this.pointInTimeRecovery = aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition] inside the given [block]
         */
        fun schemaDefinition(block: aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition.Builder.() -> kotlin.Unit) {
            this.schemaDefinition = aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.TimeToLive] inside the given [block]
         */
        fun ttl(block: aws.sdk.kotlin.services.keyspaces.model.TimeToLive.Builder.() -> kotlin.Unit) {
            this.ttl = aws.sdk.kotlin.services.keyspaces.model.TimeToLive.invoke(block)
        }
    }
}
