// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.transform

import aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification
import aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification
import aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery
import aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest
import aws.sdk.kotlin.services.keyspaces.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class RestoreTableOperationSerializer: HttpSerialize<RestoreTableRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RestoreTableRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRestoreTableOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeRestoreTableOperationBody(context: ExecutionContext, input: RestoreTableRequest): ByteArray {
    val serializer = JsonSerializer()
    val CAPACITYSPECIFICATIONOVERRIDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacitySpecificationOverride"))
    val ENCRYPTIONSPECIFICATIONOVERRIDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionSpecificationOverride"))
    val POINTINTIMERECOVERYOVERRIDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pointInTimeRecoveryOverride"))
    val RESTORETIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("restoreTimestamp"))
    val SOURCEKEYSPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceKeyspaceName"))
    val SOURCETABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceTableName"))
    val TAGSOVERRIDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tagsOverride"))
    val TARGETKEYSPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetKeyspaceName"))
    val TARGETTABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetTableName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITYSPECIFICATIONOVERRIDE_DESCRIPTOR)
        field(ENCRYPTIONSPECIFICATIONOVERRIDE_DESCRIPTOR)
        field(POINTINTIMERECOVERYOVERRIDE_DESCRIPTOR)
        field(RESTORETIMESTAMP_DESCRIPTOR)
        field(SOURCEKEYSPACENAME_DESCRIPTOR)
        field(SOURCETABLENAME_DESCRIPTOR)
        field(TAGSOVERRIDE_DESCRIPTOR)
        field(TARGETKEYSPACENAME_DESCRIPTOR)
        field(TARGETTABLENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.capacitySpecificationOverride?.let { field(CAPACITYSPECIFICATIONOVERRIDE_DESCRIPTOR, it, ::serializeCapacitySpecificationDocument) }
        input.encryptionSpecificationOverride?.let { field(ENCRYPTIONSPECIFICATIONOVERRIDE_DESCRIPTOR, it, ::serializeEncryptionSpecificationDocument) }
        input.pointInTimeRecoveryOverride?.let { field(POINTINTIMERECOVERYOVERRIDE_DESCRIPTOR, it, ::serializePointInTimeRecoveryDocument) }
        input.restoreTimestamp?.let { field(RESTORETIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.sourceKeyspaceName?.let { field(SOURCEKEYSPACENAME_DESCRIPTOR, it) }
        input.sourceTableName?.let { field(SOURCETABLENAME_DESCRIPTOR, it) }
        if (input.tagsOverride != null) {
            listField(TAGSOVERRIDE_DESCRIPTOR) {
                for (el0 in input.tagsOverride) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.targetKeyspaceName?.let { field(TARGETKEYSPACENAME_DESCRIPTOR, it) }
        input.targetTableName?.let { field(TARGETTABLENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
