// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.keyspaces.model.CapacitySpecificationSummary
import aws.sdk.kotlin.services.keyspaces.model.Comment
import aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification
import aws.sdk.kotlin.services.keyspaces.model.GetTableResponse
import aws.sdk.kotlin.services.keyspaces.model.KeyspacesException
import aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecoverySummary
import aws.sdk.kotlin.services.keyspaces.model.SchemaDefinition
import aws.sdk.kotlin.services.keyspaces.model.TableStatus
import aws.sdk.kotlin.services.keyspaces.model.TimeToLive
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetTableOperationDeserializer: HttpDeserialize<GetTableResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTableResponse {
        if (!response.status.isSuccess()) {
            throwGetTableError(context, response)
        }
        val builder = GetTableResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTableOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTableError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KeyspacesException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KeyspacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTableOperationBody(builder: GetTableResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITYSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacitySpecification"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTimestamp"))
    val DEFAULTTIMETOLIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("defaultTimeToLive"))
    val ENCRYPTIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionSpecification"))
    val KEYSPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("keyspaceName"))
    val POINTINTIMERECOVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pointInTimeRecovery"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceArn"))
    val SCHEMADEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("schemaDefinition"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tableName"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ttl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITYSPECIFICATION_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DEFAULTTIMETOLIVE_DESCRIPTOR)
        field(ENCRYPTIONSPECIFICATION_DESCRIPTOR)
        field(KEYSPACENAME_DESCRIPTOR)
        field(POINTINTIMERECOVERY_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(SCHEMADEFINITION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TABLENAME_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITYSPECIFICATION_DESCRIPTOR.index -> builder.capacitySpecification = deserializeCapacitySpecificationSummaryDocument(deserializer)
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTTIMETOLIVE_DESCRIPTOR.index -> builder.defaultTimeToLive = deserializeInt()
                ENCRYPTIONSPECIFICATION_DESCRIPTOR.index -> builder.encryptionSpecification = deserializeEncryptionSpecificationDocument(deserializer)
                KEYSPACENAME_DESCRIPTOR.index -> builder.keyspaceName = deserializeString()
                POINTINTIMERECOVERY_DESCRIPTOR.index -> builder.pointInTimeRecovery = deserializePointInTimeRecoverySummaryDocument(deserializer)
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                SCHEMADEFINITION_DESCRIPTOR.index -> builder.schemaDefinition = deserializeSchemaDefinitionDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TableStatus.fromValue(it) }
                TABLENAME_DESCRIPTOR.index -> builder.tableName = deserializeString()
                TTL_DESCRIPTOR.index -> builder.ttl = deserializeTimeToLiveDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
