// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model



/**
 * Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single Amazon Keyspaces resource.
 *
 * Amazon Web Services-assigned tag names and values are automatically assigned the `aws:` prefix, which the user cannot assign. Amazon Web Services-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix `user:` in the Cost Allocation Report. You cannot backdate the application of a tag.
 *
 * For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
 */
class Tag private constructor(builder: Builder) {
    /**
     * The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.
     */
    val key: kotlin.String? = builder.key
    /**
     * The value of the tag. Tag values are case-sensitive and can be null.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.Tag = Builder(this).apply(block).build()

    class Builder {
        /**
         * The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.
         */
        var key: kotlin.String? = null
        /**
         * The value of the tag. Tag values are case-sensitive and can be null.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.Tag = Tag(this)
    }
}
