// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model



/**
 * Amazon Keyspaces has two read/write capacity modes for processing reads and writes on your tables:
 *
 * • On-demand (default)
 *
 * • Provisioned
 *
 *  The read/write capacity mode that you choose controls how you are charged for read and write throughput and how table throughput capacity is managed.
 *
 * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
 */
class CapacitySpecification private constructor(builder: Builder) {
    /**
     * The throughput capacity specified for `read` operations defined in `read capacity units``(RCUs)`.
     */
    val readCapacityUnits: kotlin.Long? = builder.readCapacityUnits
    /**
     * The read/write throughput capacity mode for a table. The options are:
     *
     * • `throughputMode:PAY_PER_REQUEST` and
     *
     * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
     *
     * The default is `throughput_mode:PAY_PER_REQUEST`.
     *
     * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
     */
    val throughputMode: aws.sdk.kotlin.services.keyspaces.model.ThroughputMode? = builder.throughputMode
    /**
     * The throughput capacity specified for `write` operations defined in `write capacity units``(WCUs)`.
     */
    val writeCapacityUnits: kotlin.Long? = builder.writeCapacityUnits

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacitySpecification(")
        append("readCapacityUnits=$readCapacityUnits,")
        append("throughputMode=$throughputMode,")
        append("writeCapacityUnits=$writeCapacityUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = readCapacityUnits?.hashCode() ?: 0
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        result = 31 * result + (writeCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacitySpecification

        if (readCapacityUnits != other.readCapacityUnits) return false
        if (throughputMode != other.throughputMode) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The throughput capacity specified for `read` operations defined in `read capacity units``(RCUs)`.
         */
        var readCapacityUnits: kotlin.Long? = null
        /**
         * The read/write throughput capacity mode for a table. The options are:
         *
         * • `throughputMode:PAY_PER_REQUEST` and
         *
         * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
         *
         * The default is `throughput_mode:PAY_PER_REQUEST`.
         *
         * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
         */
        var throughputMode: aws.sdk.kotlin.services.keyspaces.model.ThroughputMode? = null
        /**
         * The throughput capacity specified for `write` operations defined in `write capacity units``(WCUs)`.
         */
        var writeCapacityUnits: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification) : this() {
            this.readCapacityUnits = x.readCapacityUnits
            this.throughputMode = x.throughputMode
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification = CapacitySpecification(this)
    }
}
