// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.keyspaces.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.keyspaces.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Keyspaces (for Apache Cassandra) is a scalable, highly available, and managed Apache Cassandra-compatible database service. Amazon Keyspaces makes it easy to migrate, run, and scale Cassandra workloads in the Amazon Web Services Cloud. With just a few clicks on the Amazon Web Services Management Console or a few lines of code, you can create keyspaces and tables in Amazon Keyspaces, without deploying any infrastructure or installing software.
 *
 * In addition to supporting Cassandra Query Language (CQL) requests via open-source Cassandra drivers, Amazon Keyspaces supports data definition language (DDL) operations to manage keyspaces and tables using the Amazon Web Services SDK and CLI. This API reference describes the supported DDL operations in detail.
 *
 * For the list of all supported CQL APIs, see [Supported Cassandra APIs, operations, and data types in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/cassandra-apis.html) in the *Amazon Keyspaces Developer Guide*.
 *
 * To learn how Amazon Keyspaces API actions are recorded with CloudTrail, see [Amazon Keyspaces information in CloudTrail](https://docs.aws.amazon.com/keyspaces/latest/devguide/logging-using-cloudtrail.html#service-name-info-in-cloudtrail) in the *Amazon Keyspaces Developer Guide*.
 *
 * For more information about Amazon Web Services APIs, for example how to implement retry logic or how to sign Amazon Web Services API requests, see [Amazon Web Services APIs](https://docs.aws.amazon.com/general/latest/gr/aws-apis.html) in the *General Reference*.
 */
interface KeyspacesClient : SdkClient {

    override val serviceName: String
        get() = "Keyspaces"
    /**
     * KeyspacesClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): KeyspacesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKeyspacesClient(config)
        }

        operator fun invoke(config: Config): KeyspacesClient = DefaultKeyspacesClient(config)

        /**
         * Construct a [KeyspacesClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KeyspacesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultKeyspacesClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The `CreateKeyspace` operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
     *
     * `CreateKeyspace` is an asynchronous operation. You can monitor the creation status of the new keyspace by using the `GetKeyspace` operation.
     *
     * For more information, see [Creating keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun createKeyspace(input: CreateKeyspaceRequest): CreateKeyspaceResponse

    /**
     * The `CreateKeyspace` operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
     *
     * `CreateKeyspace` is an asynchronous operation. You can monitor the creation status of the new keyspace by using the `GetKeyspace` operation.
     *
     * For more information, see [Creating keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun createKeyspace(block: CreateKeyspaceRequest.Builder.() -> Unit) = createKeyspace(CreateKeyspaceRequest.Builder().apply(block).build())

    /**
     * The `CreateTable` operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
     *
     * `CreateTable` is an asynchronous operation. When the request is received, the status of the table is set to `CREATING`. You can monitor the creation status of the new table by using the `GetTable` operation, which returns the current `status` of the table. You can start using a table when the status is `ACTIVE`.
     *
     * For more information, see [Creating tables](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun createTable(input: CreateTableRequest): CreateTableResponse

    /**
     * The `CreateTable` operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
     *
     * `CreateTable` is an asynchronous operation. When the request is received, the status of the table is set to `CREATING`. You can monitor the creation status of the new table by using the `GetTable` operation, which returns the current `status` of the table. You can start using a table when the status is `ACTIVE`.
     *
     * For more information, see [Creating tables](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun createTable(block: CreateTableRequest.Builder.() -> Unit) = createTable(CreateTableRequest.Builder().apply(block).build())

    /**
     * The `DeleteKeyspace` operation deletes a keyspace and all of its tables.
     */
    suspend fun deleteKeyspace(input: DeleteKeyspaceRequest): DeleteKeyspaceResponse

    /**
     * The `DeleteKeyspace` operation deletes a keyspace and all of its tables.
     */
    suspend fun deleteKeyspace(block: DeleteKeyspaceRequest.Builder.() -> Unit) = deleteKeyspace(DeleteKeyspaceRequest.Builder().apply(block).build())

    /**
     * The `DeleteTable` operation deletes a table and all of its data. After a `DeleteTable` request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
     */
    suspend fun deleteTable(input: DeleteTableRequest): DeleteTableResponse

    /**
     * The `DeleteTable` operation deletes a table and all of its data. After a `DeleteTable` request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
     */
    suspend fun deleteTable(block: DeleteTableRequest.Builder.() -> Unit) = deleteTable(DeleteTableRequest.Builder().apply(block).build())

    /**
     * Returns the name and the Amazon Resource Name (ARN) of the specified table.
     */
    suspend fun getKeyspace(input: GetKeyspaceRequest): GetKeyspaceResponse

    /**
     * Returns the name and the Amazon Resource Name (ARN) of the specified table.
     */
    suspend fun getKeyspace(block: GetKeyspaceRequest.Builder.() -> Unit) = getKeyspace(GetKeyspaceRequest.Builder().apply(block).build())

    /**
     * Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
     *
     * To read table metadata using `GetTable`, `Select` action permissions for the table and system tables are required to complete the operation.
     */
    suspend fun getTable(input: GetTableRequest): GetTableResponse

    /**
     * Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
     *
     * To read table metadata using `GetTable`, `Select` action permissions for the table and system tables are required to complete the operation.
     */
    suspend fun getTable(block: GetTableRequest.Builder.() -> Unit) = getTable(GetTableRequest.Builder().apply(block).build())

    /**
     * Returns a list of keyspaces.
     */
    suspend fun listKeyspaces(input: ListKeyspacesRequest): ListKeyspacesResponse

    /**
     * Returns a list of keyspaces.
     */
    suspend fun listKeyspaces(block: ListKeyspacesRequest.Builder.() -> Unit) = listKeyspaces(ListKeyspacesRequest.Builder().apply(block).build())

    /**
     * Returns a list of tables for a specified keyspace.
     */
    suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * Returns a list of tables for a specified keyspace.
     */
    suspend fun listTables(block: ListTablesRequest.Builder.() -> Unit) = listTables(ListTablesRequest.Builder().apply(block).build())

    /**
     * Returns a list of all tags associated with the specified Amazon Keyspaces resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of all tags associated with the specified Amazon Keyspaces resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Restores the specified table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [ Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
     *
     * Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
     *
     * When you restore using point in time recovery, Amazon Keyspaces restores your source table's schema and data to the state based on the selected timestamp `(day:hour:minute:second)` to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.
     *
     * In addition to the table's schema, data, and TTL settings, `RestoreTable` restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table's schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table's settings as of the current time or when the table was deleted.
     *
     * You can also overwrite these settings during restore:
     *
     * • Read/write capacity mode
     *
     * • Provisioned throughput capacity settings
     *
     * • Point-in-time (PITR) settings
     *
     * • Tags
     *
     * For more information, see [PITR restore settings](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings) in the *Amazon Keyspaces Developer Guide*.
     *
     * Note that the following settings are not restored, and you must configure them manually for the new table:
     *
     * • Automatic scaling policies (for tables that use provisioned capacity mode)
     *
     * • Identity and Access Management (IAM) policies
     *
     * • Amazon CloudWatch metrics and alarms
     */
    suspend fun restoreTable(input: RestoreTableRequest): RestoreTableResponse

    /**
     * Restores the specified table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [ Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
     *
     * Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
     *
     * When you restore using point in time recovery, Amazon Keyspaces restores your source table's schema and data to the state based on the selected timestamp `(day:hour:minute:second)` to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.
     *
     * In addition to the table's schema, data, and TTL settings, `RestoreTable` restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table's schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table's settings as of the current time or when the table was deleted.
     *
     * You can also overwrite these settings during restore:
     *
     * • Read/write capacity mode
     *
     * • Provisioned throughput capacity settings
     *
     * • Point-in-time (PITR) settings
     *
     * • Tags
     *
     * For more information, see [PITR restore settings](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings) in the *Amazon Keyspaces Developer Guide*.
     *
     * Note that the following settings are not restored, and you must configure them manually for the new table:
     *
     * • Automatic scaling policies (for tables that use provisioned capacity mode)
     *
     * • Identity and Access Management (IAM) policies
     *
     * • Amazon CloudWatch metrics and alarms
     */
    suspend fun restoreTable(block: RestoreTableRequest.Builder.() -> Unit) = restoreTable(RestoreTableRequest.Builder().apply(block).build())

    /**
     * Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
     *
     * For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see [Amazon Keyspaces resource access based on tags](https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
     *
     * For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see [Amazon Keyspaces resource access based on tags](https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags) in the *Amazon Keyspaces Developer Guide*.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the association of tags from a Amazon Keyspaces resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the association of tags from a Amazon Keyspaces resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
     */
    suspend fun updateTable(input: UpdateTableRequest): UpdateTableResponse

    /**
     * Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
     */
    suspend fun updateTable(block: UpdateTableRequest.Builder.() -> Unit) = updateTable(UpdateTableRequest.Builder().apply(block).build())
}
