// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendraranking.serde

import aws.sdk.kotlin.services.kendraranking.model.CreateRescoreExecutionPlanResponse
import aws.sdk.kotlin.services.kendraranking.model.KendraRankingException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRescoreExecutionPlanOperationDeserializer: HttpDeserializer.NonStreaming<CreateRescoreExecutionPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRescoreExecutionPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRescoreExecutionPlanError(context, call, payload)
        }
        val builder = CreateRescoreExecutionPlanResponse.Builder()

        if (payload != null) {
            deserializeCreateRescoreExecutionPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRescoreExecutionPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraRankingException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraRankingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRescoreExecutionPlanOperationBody(builder: CreateRescoreExecutionPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
