// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendraranking.paginators

import aws.sdk.kotlin.services.kendraranking.KendraRankingClient
import aws.sdk.kotlin.services.kendraranking.model.ListRescoreExecutionPlansRequest
import aws.sdk.kotlin.services.kendraranking.model.ListRescoreExecutionPlansResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListRescoreExecutionPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRescoreExecutionPlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRescoreExecutionPlansResponse]
 */
public fun KendraRankingClient.listRescoreExecutionPlansPaginated(initialRequest: ListRescoreExecutionPlansRequest = ListRescoreExecutionPlansRequest { }): Flow<ListRescoreExecutionPlansResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRescoreExecutionPlansPaginated.listRescoreExecutionPlans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRescoreExecutionPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRescoreExecutionPlansResponse]
 */
public fun KendraRankingClient.listRescoreExecutionPlansPaginated(block: ListRescoreExecutionPlansRequest.Builder.() -> Unit): Flow<ListRescoreExecutionPlansResponse> =
    listRescoreExecutionPlansPaginated(ListRescoreExecutionPlansRequest.Builder().apply(block).build())
