// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendraranking.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a document from a search service such as OpenSearch (self managed). Amazon Kendra Intelligent Ranking uses this information to rank and score on.
 */
public class Document private constructor(builder: Builder) {
    /**
     * The body text of the search service's document.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The optional group identifier of the document from the search service. Documents with the same group identifier are grouped together and processed as one document within the service.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The identifier of the document from the search service.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The original document score or rank from the search service. Amazon Kendra Intelligent Ranking gives the document a new score or rank based on its intelligent search algorithms.
     */
    public val originalScore: kotlin.Float = requireNotNull(builder.originalScore) { "A non-null value must be provided for originalScore" }
    /**
     * The title of the search service's document.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The body text of the search service's document represented as a list of tokens or words. You must choose to provide `Body` or `TokenizedBody`. You cannot provide both.
     */
    public val tokenizedBody: List<String>? = builder.tokenizedBody
    /**
     * The title of the search service's document represented as a list of tokens or words. You must choose to provide `Title` or `TokenizedTitle`. You cannot provide both.
     */
    public val tokenizedTitle: List<String>? = builder.tokenizedTitle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendraranking.model.Document = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Document(")
        append("body=$body,")
        append("groupId=$groupId,")
        append("id=$id,")
        append("originalScore=$originalScore,")
        append("title=$title,")
        append("tokenizedBody=$tokenizedBody,")
        append("tokenizedTitle=$tokenizedTitle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (originalScore.hashCode())
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (tokenizedBody?.hashCode() ?: 0)
        result = 31 * result + (tokenizedTitle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Document

        if (body != other.body) return false
        if (groupId != other.groupId) return false
        if (id != other.id) return false
        if (!(originalScore?.equals(other.originalScore) ?: (other.originalScore == null))) return false
        if (title != other.title) return false
        if (tokenizedBody != other.tokenizedBody) return false
        if (tokenizedTitle != other.tokenizedTitle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendraranking.model.Document = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The body text of the search service's document.
         */
        public var body: kotlin.String? = null
        /**
         * The optional group identifier of the document from the search service. Documents with the same group identifier are grouped together and processed as one document within the service.
         */
        public var groupId: kotlin.String? = null
        /**
         * The identifier of the document from the search service.
         */
        public var id: kotlin.String? = null
        /**
         * The original document score or rank from the search service. Amazon Kendra Intelligent Ranking gives the document a new score or rank based on its intelligent search algorithms.
         */
        public var originalScore: kotlin.Float? = null
        /**
         * The title of the search service's document.
         */
        public var title: kotlin.String? = null
        /**
         * The body text of the search service's document represented as a list of tokens or words. You must choose to provide `Body` or `TokenizedBody`. You cannot provide both.
         */
        public var tokenizedBody: List<String>? = null
        /**
         * The title of the search service's document represented as a list of tokens or words. You must choose to provide `Title` or `TokenizedTitle`. You cannot provide both.
         */
        public var tokenizedTitle: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendraranking.model.Document) : this() {
            this.body = x.body
            this.groupId = x.groupId
            this.id = x.id
            this.originalScore = x.originalScore
            this.title = x.title
            this.tokenizedBody = x.tokenizedBody
            this.tokenizedTitle = x.tokenizedTitle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendraranking.model.Document = Document(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (originalScore == null) originalScore = 0f
            return this
        }
    }
}
