// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendraranking

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.kendraranking.auth.KendraRankingAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.kendraranking.auth.KendraRankingIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.kendraranking.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.kendraranking.model.*
import aws.sdk.kotlin.services.kendraranking.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultKendraRankingClient(override val config: KendraRankingClient.Config) : KendraRankingClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = KendraRankingIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "kendra-ranking")
        }
        toMap()
    }
    private val authSchemeAdapter = KendraRankingAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.kendraranking"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API. You set the number of capacity units that you require for Amazon Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     *
     * For an example of using the `CreateRescoreExecutionPlan` API, including using the Python and Java SDKs, see [Semantically ranking a search service's results](https://docs.aws.amazon.com/kendra/latest/dg/search-service-rerank.html).
     */
    override suspend fun createRescoreExecutionPlan(input: CreateRescoreExecutionPlanRequest): CreateRescoreExecutionPlanResponse {
        val op = SdkHttpOperation.build<CreateRescoreExecutionPlanRequest, CreateRescoreExecutionPlanResponse> {
            serializeWith = CreateRescoreExecutionPlanOperationSerializer()
            deserializeWith = CreateRescoreExecutionPlanOperationDeserializer()
            operationName = "CreateRescoreExecutionPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API.
     */
    override suspend fun deleteRescoreExecutionPlan(input: DeleteRescoreExecutionPlanRequest): DeleteRescoreExecutionPlanResponse {
        val op = SdkHttpOperation.build<DeleteRescoreExecutionPlanRequest, DeleteRescoreExecutionPlanResponse> {
            serializeWith = DeleteRescoreExecutionPlanOperationSerializer()
            deserializeWith = DeleteRescoreExecutionPlanOperationDeserializer()
            operationName = "DeleteRescoreExecutionPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API.
     */
    override suspend fun describeRescoreExecutionPlan(input: DescribeRescoreExecutionPlanRequest): DescribeRescoreExecutionPlanResponse {
        val op = SdkHttpOperation.build<DescribeRescoreExecutionPlanRequest, DescribeRescoreExecutionPlanResponse> {
            serializeWith = DescribeRescoreExecutionPlanOperationSerializer()
            deserializeWith = DescribeRescoreExecutionPlanOperationDeserializer()
            operationName = "DescribeRescoreExecutionPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API.
     */
    override suspend fun listRescoreExecutionPlans(input: ListRescoreExecutionPlansRequest): ListRescoreExecutionPlansResponse {
        val op = SdkHttpOperation.build<ListRescoreExecutionPlansRequest, ListRescoreExecutionPlansResponse> {
            serializeWith = ListRescoreExecutionPlansOperationSerializer()
            deserializeWith = ListRescoreExecutionPlansOperationDeserializer()
            operationName = "ListRescoreExecutionPlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of tags associated with a specified resource. A rescore execution plan is an example of a resource that can have tags associated with it.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rescores or re-ranks search results from a search service such as OpenSearch (self managed). You use the semantic search capabilities of Amazon Kendra Intelligent Ranking to improve the search service's results.
     */
    override suspend fun rescore(input: RescoreRequest): RescoreResponse {
        val op = SdkHttpOperation.build<RescoreRequest, RescoreResponse> {
            serializeWith = RescoreOperationSerializer()
            deserializeWith = RescoreOperationDeserializer()
            operationName = "Rescore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a specified tag to a specified rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API. If the tag already exists, the existing value is replaced with the new value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` operation.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the `Rescore` API. You can update the number of capacity units you require for Amazon Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     */
    override suspend fun updateRescoreExecutionPlan(input: UpdateRescoreExecutionPlanRequest): UpdateRescoreExecutionPlanResponse {
        val op = SdkHttpOperation.build<UpdateRescoreExecutionPlanRequest, UpdateRescoreExecutionPlanResponse> {
            serializeWith = UpdateRescoreExecutionPlanOperationSerializer()
            deserializeWith = UpdateRescoreExecutionPlanOperationDeserializer()
            operationName = "UpdateRescoreExecutionPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSKendraRerankingFrontendService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "kendra-ranking")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
