// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.AttributeFilter
import aws.sdk.kotlin.services.kendra.model.DocumentRelevanceConfiguration
import aws.sdk.kotlin.services.kendra.model.RetrieveRequest
import aws.sdk.kotlin.services.kendra.model.UserContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RetrieveOperationSerializer: HttpSerializer.NonStreaming<RetrieveRequest> {
    override fun serialize(context: ExecutionContext, input: RetrieveRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeRetrieveOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeRetrieveOperationBody(context: ExecutionContext, input: RetrieveRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeFilter"))
    val DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DocumentRelevanceOverrideConfigurations"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val PAGENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageNumber"))
    val PAGESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageSize"))
    val QUERYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryText"))
    val REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RequestedDocumentAttributes"))
    val USERCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserContext"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEFILTER_DESCRIPTOR)
        field(DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(PAGENUMBER_DESCRIPTOR)
        field(PAGESIZE_DESCRIPTOR)
        field(QUERYTEXT_DESCRIPTOR)
        field(REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR)
        field(USERCONTEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributeFilter?.let { field(ATTRIBUTEFILTER_DESCRIPTOR, it, ::serializeAttributeFilterDocument) }
        if (input.documentRelevanceOverrideConfigurations != null) {
            listField(DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.documentRelevanceOverrideConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDocumentRelevanceConfigurationDocument))
                }
            }
        }
        input.indexId?.let { field(INDEXID_DESCRIPTOR, it) }
        input.pageNumber?.let { field(PAGENUMBER_DESCRIPTOR, it) }
        input.pageSize?.let { field(PAGESIZE_DESCRIPTOR, it) }
        input.queryText?.let { field(QUERYTEXT_DESCRIPTOR, it) }
        if (input.requestedDocumentAttributes != null) {
            listField(REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.requestedDocumentAttributes) {
                    serializeString(el0)
                }
            }
        }
        input.userContext?.let { field(USERCONTEXT_DESCRIPTOR, it, ::serializeUserContextDocument) }
    }
    return serializer.toByteArray()
}
