// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.serde

import aws.sdk.kotlin.services.kendra.model.FacetResult
import aws.sdk.kotlin.services.kendra.model.FeaturedResultsItem
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.QueryResponse
import aws.sdk.kotlin.services.kendra.model.QueryResultItem
import aws.sdk.kotlin.services.kendra.model.SpellCorrectedQuery
import aws.sdk.kotlin.services.kendra.model.Warning
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class QueryOperationDeserializer: HttpDeserializer.NonStreaming<QueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): QueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryError(context, call, payload)
        }
        val builder = QueryResponse.Builder()

        if (payload != null) {
            deserializeQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryOperationBody(builder: QueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACETRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FacetResults"))
    val FEATUREDRESULTSITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeaturedResultsItems"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val RESULTITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultItems"))
    val SPELLCORRECTEDQUERIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SpellCorrectedQueries"))
    val TOTALNUMBEROFRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalNumberOfResults"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACETRESULTS_DESCRIPTOR)
        field(FEATUREDRESULTSITEMS_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(RESULTITEMS_DESCRIPTOR)
        field(SPELLCORRECTEDQUERIES_DESCRIPTOR)
        field(TOTALNUMBEROFRESULTS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACETRESULTS_DESCRIPTOR.index -> builder.facetResults =
                    deserializer.deserializeList(FACETRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FacetResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFacetResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREDRESULTSITEMS_DESCRIPTOR.index -> builder.featuredResultsItems =
                    deserializer.deserializeList(FEATUREDRESULTSITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<FeaturedResultsItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeaturedResultsItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                RESULTITEMS_DESCRIPTOR.index -> builder.resultItems =
                    deserializer.deserializeList(RESULTITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryResultItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryResultItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SPELLCORRECTEDQUERIES_DESCRIPTOR.index -> builder.spellCorrectedQueries =
                    deserializer.deserializeList(SPELLCORRECTEDQUERIES_DESCRIPTOR) {
                        val col0 = mutableListOf<SpellCorrectedQuery>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSpellCorrectedQueryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALNUMBEROFRESULTS_DESCRIPTOR.index -> builder.totalNumberOfResults = deserializeInt()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Warning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
